/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.dataAccess.shape.ShapeUtils;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;

public abstract class ESRIRecord
extends ShapeUtils {
    public int recordNumber;
    public int contentLength;

    public ESRIRecord() {
        this.recordNumber = 0;
        this.contentLength = 0;
    }

    public ESRIRecord(byte[] b, int off) {
        this.recordNumber = ESRIRecord.readBEInt(b, off);
        this.contentLength = ESRIRecord.readBEInt(b, off + 4);
    }

    public abstract void addOMGraphics(OMGraphicList var1, DrawingAttributes var2);

    public abstract OMGeometry addOMGeometry(OMGeometryList var1);

    public abstract ESRIBoundingBox getBoundingBox();

    public abstract int getShapeType();

    public abstract int getRecordLength();

    public int getBinaryStoreSize() {
        return this.getRecordLength() + 8;
    }

    public int write(byte[] b, int off) {
        int nBytes = ESRIRecord.writeBEInt(b, off, this.recordNumber);
        nBytes += ESRIRecord.writeBEInt(b, off + nBytes, this.getRecordLength() / 2);
        return nBytes;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getContentLength() {
        return this.contentLength;
    }
}

