/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.util.Debug;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class RpfFileSearch {
    protected Vector<String> files = new Vector();

    public RpfFileSearch() {
    }

    public RpfFileSearch(String startingDir) {
        this.handleEntry(startingDir);
    }

    public boolean handleEntry(String startingDir) {
        File startingFile = null;
        if (startingDir != null && !(startingFile = new File(startingDir)).exists()) {
            startingFile = null;
            Debug.output("RpfFileSearch: " + startingDir + " doesn't exist.");
            return false;
        }
        if (startingFile == null) {
            return false;
        }
        boolean rpfDir = false;
        String start = startingFile.getAbsolutePath();
        if (start.indexOf("RPF") != -1 || start.indexOf("rpf") != -1) {
            rpfDir = true;
        }
        if (Debug.debugging("maketoc")) {
            Debug.output("RpfFileSearch: Starting RPF file search from " + startingDir + ", RPF directory " + (rpfDir ? "found." : "not found."));
        }
        this.handleEntry(startingFile, rpfDir);
        return true;
    }

    public void handleEntry(File file, boolean RPFDirFound) {
        try {
            String[] filenames = file.list();
            boolean dirTest = false;
            boolean not14 = false;
            try {
                Method method = file.getClass().getDeclaredMethod("isDirectory", null);
                Object obj = method.invoke((Object)file, (Object[])null);
                if (obj instanceof Boolean) {
                    dirTest = (Boolean)obj;
                }
            }
            catch (NoSuchMethodException nsme) {
                not14 = true;
            }
            catch (SecurityException se) {
                not14 = true;
            }
            catch (IllegalAccessException iae) {
                not14 = true;
            }
            catch (IllegalArgumentException iae2) {
                not14 = true;
            }
            catch (InvocationTargetException ite) {
                not14 = true;
            }
            if ((dirTest || not14) && filenames != null) {
                int i;
                if (Debug.debugging("maketocdetail")) {
                    Debug.output("RpfFileSearch.handleEntry(" + file + ", " + RPFDirFound + "), file is a directory");
                }
                File[] contents = new File[filenames.length];
                for (i = 0; i < contents.length; ++i) {
                    contents[i] = new File(file, filenames[i]);
                }
                for (i = 0; i < contents.length; ++i) {
                    boolean rpf = false;
                    if (!RPFDirFound) {
                        rpf = filenames[i].equalsIgnoreCase("RPF");
                    }
                    this.handleEntry(contents[i], RPFDirFound || rpf);
                }
            } else {
                if (Debug.debugging("maketocdetail")) {
                    Debug.output("RpfFileSearch.handleEntry(" + file + ", " + RPFDirFound + "), adding to list...");
                }
                String parent = file.getParent();
                if (RPFDirFound) {
                    if (parent != null) {
                        this.files.add(file.getParent() + File.separator + file.getName());
                    } else {
                        this.files.add("." + File.separator + file.getName());
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public String[] getFiles() {
        String[] fs = new String[this.files.size()];
        this.files.toArray(fs);
        return fs;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("RpfFileSearch:\n");
        for (int i = 0; i < this.files.size(); ++i) {
            s.append("  file ").append(i).append(": ").append(this.files.elementAt(i)).append("\n");
        }
        return s.toString();
    }

    public static void main(String[] argv) {
        Debug.init();
        RpfFileSearch search = new RpfFileSearch();
        for (int i = 0; i < argv.length; ++i) {
            search.handleEntry(argv[i]);
        }
        System.out.println(search);
    }
}

