/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import com.bbn.openmap.layer.location.db.RecordSet;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LocationData {
    protected String cityName;
    protected String stateName;
    protected String graphicName;
    protected float latitude;
    protected float longitude;
    protected String queryString = null;

    public LocationData(RecordSet drs) throws SQLException {
        ResultSet rset = drs.getResultSet();
        this.cityName = rset.getString(1);
        this.stateName = rset.getString(2);
        this.graphicName = rset.getString(3);
        this.latitude = rset.getFloat(4);
        this.longitude = rset.getFloat(5);
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getGraphicName() {
        return this.graphicName;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String inQueryString) {
        this.queryString = inQueryString;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Location Data values:\n");
        s.append(" City Name = ").append(this.cityName).append("\n");
        s.append(" State Name = ").append(this.stateName).append("\n");
        s.append(" Graphic = ").append(this.graphicName).append("\n");
        s.append(" Latitude = ").append(this.latitude).append("\n");
        s.append(" Longitude = ").append(this.longitude).append("\n");
        return s.toString();
    }

    public static void main(String[] args) {
        System.out.println("\n*** LocationData handles results from the following query: ***\n");
        System.out.println(" select CITY (string), STATE (string), GRAPHIC (string, url or graphic name), LATITUDE (float), LONGITUDE (float) from LOCATION_TABLE (tablename where data is stored)\n");
        System.out.println("Note: Column names and tablename should reflect whatever is stored in the database.  Data types should match what this class is expecting, in the order listed here.\n");
    }
}

