/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkText
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static String DEFAULT_FONT = "-*-SansSerif-normal-o-normal--12-*-*-*-*-*-*";

    public static void write(float latPoint, float lonPoint, String stuff, String font, int just, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<T>".getBytes());
        dos.writeByte(2);
        dos.writeByte(1);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeByte(just);
        properties.setProperty("ts", stuff);
        properties.setProperty("tf", font);
        properties.write(dos);
    }

    public static void write(int x1, int y1, String stuff, String font, int just, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<T>".getBytes());
        dos.writeByte(2);
        dos.writeByte(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeByte(just);
        properties.setProperty("ts", stuff);
        properties.setProperty("tf", font);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int offset_x1, int offset_y1, String stuff, String font, int just, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<T>".getBytes());
        dos.writeByte(2);
        dos.writeByte(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeByte(just);
        properties.setProperty("ts", stuff);
        properties.setProperty("tf", font);
        properties.write(dos);
    }

    public static void write(OMText text, Link link, LinkProperties props) throws IOException {
        switch (text.getRenderType()) {
            case 1: {
                LinkText.write((float)text.getLat(), (float)text.getLon(), text.getData(), OMText.fontToXFont(text.getFont()), text.getJustify(), props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                LinkText.write(text.getX(), text.getY(), text.getData(), OMText.fontToXFont(text.getFont()), text.getJustify(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LinkText.write((float)text.getLat(), (float)text.getLon(), text.getX(), text.getY(), text.getData(), OMText.fontToXFont(text.getFont()), text.getJustify(), props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkText.write: text rendertype unknown.");
            }
        }
    }

    public static OMText read(DataInputStream dis) throws IOException {
        return LinkText.read(dis, null);
    }

    public static OMText read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMText text = null;
        float lat = 0.0f;
        float lon = 0.0f;
        int x = 0;
        int y = 0;
        byte just = 0;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 3: {
                lat = dis.readFloat();
                lon = dis.readFloat();
            }
            case 2: {
                x = dis.readInt();
                y = dis.readInt();
                break;
            }
            default: {
                lat = dis.readFloat();
                lon = dis.readFloat();
            }
        }
        just = dis.readByte();
        LinkProperties properties = (LinkProperties)LinkProperties.read(dis, propertiesBuffer).clone();
        String string = properties.getProperty("ts");
        String font = properties.getProperty("tf");
        if (string == null) {
            string = "";
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        switch (renderType) {
            case 3: {
                text = new OMText(lat, lon, x, y, string, OMText.rebuildFont(font), just);
                break;
            }
            case 2: {
                text = new OMText(x, y, string, OMText.rebuildFont(font), (int)just);
                break;
            }
            default: {
                text = new OMText(lat, lon, string, OMText.rebuildFont(font), (int)just);
            }
        }
        if (text != null) {
            properties.setProperties(text);
            text.setBaseline(PropUtils.intFromProperties(properties, "tbl", 0));
            text.setRotationAngle(ProjMath.degToRad(PropUtils.floatFromProperties(properties, "rot", 0.0f)));
        }
        return text;
    }
}

