/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.learn;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleAnimationLayer
extends OMGraphicHandlerLayer {
    OMGraphicList movingPoints = new OMGraphicList();
    double movementFactor = 4.0;
    Timer timer;
    int timerDelay = 3000;
    JPanel panel = null;
    JButton addButton = null;
    JCheckBox timerButton = null;
    JSpinner spinner = null;
    JLabel spriteCountLabel = null;

    public synchronized OMGraphicList prepare() {
        OMGraphicList ret = new OMGraphicList(this.movingPoints);
        ret.generate(this.getProjection());
        return ret;
    }

    public void removed(Container cont) {
        this.movingPoints.clear();
        this.stopTimer();
    }

    public void addMovingPoint() {
        Projection proj = this.getProjection();
        if (proj == null) {
            return;
        }
        int numOfSpritesToAdd = 1;
        if (this.spinner != null) {
            try {
                numOfSpritesToAdd = Integer.parseInt(this.spinner.getValue().toString());
            }
            catch (NumberFormatException nfe) {
                this.spinner.setValue(1);
            }
        }
        double mapHeight = proj.getHeight();
        double mapWidth = proj.getWidth();
        for (int i = 0; i < numOfSpritesToAdd; ++i) {
            double ranY = Math.random() * mapHeight;
            double ranX = Math.random() * mapWidth;
            Object newLoc = proj.inverse(ranX, ranY);
            OMPoint point = new OMPoint(((Point2D)newLoc).getY(), ((Point2D)newLoc).getX(), 5);
            point.setFillPaint(Color.red);
            this.movingPoints.add(point);
        }
        this.spriteCountLabel.setText(Integer.toString(this.movingPoints.size()));
        this.doPrepare();
    }

    public void clearMovingPoints() {
        this.movingPoints.clear();
        this.spriteCountLabel.setText(Integer.toString(this.movingPoints.size()));
        this.doPrepare();
        this.stopTimer();
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
        if (this.timerButton != null) {
            this.timerButton.setSelected(false);
        }
    }

    public void resetTimer(int interval) {
        this.timerDelay = interval;
        this.stopTimer();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new ManageGraphicsTask(this), 0L, (long)this.timerDelay);
        if (this.timerButton != null) {
            this.timerButton.setSelected(true);
        }
    }

    public Component getGUI() {
        if (this.panel == null) {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.panel = new JPanel(gridbag);
            this.addButton = new JButton("Add Sprites");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    SimpleAnimationLayer.this.addMovingPoint();
                }
            });
            c.insets = new Insets(5, 5, 5, 2);
            c.anchor = 18;
            gridbag.setConstraints(this.addButton, c);
            this.panel.add(this.addButton);
            JButton clearButton = new JButton("Clear Sprites");
            clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    SimpleAnimationLayer.this.clearMovingPoints();
                }
            });
            c.insets = new Insets(5, 2, 5, 5);
            c.anchor = 12;
            c.gridwidth = 0;
            gridbag.setConstraints(clearButton, c);
            this.panel.add(clearButton);
            JLabel numSpritesLabel = new JLabel("Number of Sprites to Add:");
            SpinnerNumberModel numSpritesSpinnerModel = new SpinnerNumberModel(1, 1, 50, 1);
            this.spinner = new JSpinner(numSpritesSpinnerModel);
            numSpritesLabel.setLabelFor(this.spinner);
            c.insets = new Insets(0, 5, 5, 5);
            c.anchor = 17;
            c.gridwidth = -1;
            gridbag.setConstraints(numSpritesLabel, c);
            this.panel.add(numSpritesLabel);
            c.anchor = 13;
            c.gridwidth = 0;
            gridbag.setConstraints(this.spinner, c);
            this.panel.add(this.spinner);
            JLabel numMapSpritesLabel = new JLabel("Number of Sprites on Map:");
            this.spriteCountLabel = new JLabel(Integer.toString(this.movingPoints.size()));
            c.insets = new Insets(0, 5, 5, 5);
            c.anchor = 17;
            c.gridwidth = -1;
            gridbag.setConstraints(numMapSpritesLabel, c);
            this.panel.add(numMapSpritesLabel);
            c.anchor = 13;
            c.gridwidth = 0;
            gridbag.setConstraints(this.spriteCountLabel, c);
            this.panel.add(this.spriteCountLabel);
            JSlider slider = new JSlider(0, 0, 20, 10);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(5), new JLabel(".5"));
            dict.put(new Integer(10), new JLabel("1"));
            dict.put(new Integer(15), new JLabel("1.5"));
            dict.put(new Integer(20), new JLabel("2"));
            slider.setLabelTable(dict);
            slider.setPaintLabels(true);
            slider.setMajorTickSpacing(2);
            slider.setPaintTicks(true);
            slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider2 = (JSlider)ce.getSource();
                    if (slider2.getValueIsAdjusting()) {
                        float interval = ((float)slider2.getValue() + 0.01f) * 100.0f;
                        Debug.output("SimpleAnimationLayer delay set to: " + interval / 1000.0f + " seconds");
                        SimpleAnimationLayer.this.resetTimer((int)interval);
                    }
                }
            });
            JPanel sliderPanel = PaletteHelper.createHorizontalPanel("Timer interval in seconds:");
            sliderPanel.add(slider);
            c.insets = new Insets(0, 5, 5, 5);
            c.anchor = 17;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(sliderPanel, c);
            this.panel.add(sliderPanel);
            this.timerButton = new JCheckBox("Run Timer", this.timer != null);
            this.timerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox check = (JCheckBox)ae.getSource();
                    if (check.isSelected()) {
                        SimpleAnimationLayer.this.resetTimer(SimpleAnimationLayer.this.timerDelay);
                    } else {
                        SimpleAnimationLayer.this.stopTimer();
                    }
                }
            });
            gridbag.setConstraints(this.timerButton, c);
            this.panel.add(this.timerButton);
        }
        return this.panel;
    }

    public class ManageGraphicsTask
    extends TimerTask {
        final SimpleAnimationLayer sal;

        public ManageGraphicsTask(SimpleAnimationLayer layer) {
            this.sal = layer;
        }

        public void run() {
            Projection proj = this.sal.getProjection();
            OMGraphicList safeList = new OMGraphicList(this.sal.movingPoints);
            for (OMGraphic point : safeList) {
                if (point instanceof OMPoint) {
                    this.moveRandomly((OMPoint)point, this.sal.movementFactor, proj);
                } else if (point instanceof OMScalingIcon) {
                    this.moveRandomly((OMScalingIcon)point, this.sal.movementFactor, proj);
                }
                if (proj == null) continue;
                point.generate(proj);
            }
            this.sal.repaint();
        }

        protected void moveRandomly(OMPoint point, double factor, Projection proj) {
            double hor = Math.random() - 0.5;
            double vert = Math.random() - 0.5;
            Point2D mapPoint = proj.forward(point.getLat(), point.getLon());
            mapPoint.setLocation(mapPoint.getX() + hor * factor, mapPoint.getY() + vert * factor);
            Object llp = proj.inverse(mapPoint);
            point.setLat(((Point2D)llp).getY());
            point.setLon(((Point2D)llp).getX());
        }

        protected void moveRandomly(OMScalingIcon point, double factor, Projection proj) {
            double hor = Math.random() - 0.5;
            double vert = Math.random() - 0.5;
            Point2D mapPoint = proj.forward(point.getLat(), point.getLon());
            mapPoint.setLocation(mapPoint.getX() + hor * factor, mapPoint.getY() + vert * factor);
            Object llp = proj.inverse(mapPoint);
            point.setLat(((Point2D)llp).getY());
            point.setLon(((Point2D)llp).getX());
        }
    }
}

