/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.learn;

import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.learn.BasicLayer;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionLayer
extends BasicLayer {
    public InteractionLayer() {
        this.setName("Interaction Layer");
        this.setProjectionChangePolicy(new StandardPCPolicy(this, true));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    @Override
    public OMGraphicList init() {
        OMGraphicList omList = new OMGraphicList();
        OMLine line = new OMLine(40.0, -75.0, 42.0, -70.0, 3);
        line.setStroke(new BasicStroke(2.0f));
        line.putAttribute("Label", new OMTextLabeler("Line Label"));
        line.setLinePaint(Color.red);
        line.setSelectPaint(Color.blue);
        line.putAttribute("Tooltip", "This is an OMLine.");
        omList.add(line);
        OMGraphicList pointList = new OMGraphicList();
        for (int i = 0; i < 100; ++i) {
            OMPoint point = new OMPoint((float)(Math.random() * 89.0), (float)(Math.random() * -179.0), 3);
            point.putAttribute("Tooltip", "This is OMPoint #" + i);
            point.setLinePaint(Color.green);
            point.setSelectPaint(Color.yellow);
            pointList.add(point);
        }
        omList.add(pointList);
        return omList;
    }

    @Override
    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    @Override
    public boolean isSelectable(OMGraphic omg) {
        return true;
    }

    @Override
    public void select(OMGraphicList list) {
        super.select(list);
        if (this.selectedList != null) {
            System.out.println("Current selection list: " + this.selectedList.getDescription());
        }
    }

    @Override
    public void deselect(OMGraphicList list) {
        super.deselect(list);
        if (this.selectedList != null) {
            System.out.println("Current selection list: " + this.selectedList.getDescription());
        }
    }

    @Override
    public String getInfoText(OMGraphic omg) {
        String classname = omg.getClass().getName();
        return "Interaction Layer OMGraphic - " + classname.substring(classname.lastIndexOf(46) + 1);
    }

    @Override
    public String getToolTipTextFor(OMGraphic omg) {
        Object tt = omg.getAttribute("Tooltip");
        if (tt instanceof String) {
            return (String)tt;
        }
        return null;
    }

    @Override
    public List<Component> getItemsForMapMenu(MapMouseEvent me) {
        ArrayList<Component> l = new ArrayList<Component>();
        JMenuItem when = new JMenuItem("When");
        when.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("When was chosen.");
            }
        });
        JMenuItem where = new JMenuItem("Where");
        where.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("Where was chosen.");
            }
        });
        JMenuItem how = new JMenuItem("How");
        how.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("How was chosen.");
            }
        });
        l.add(when);
        l.add(where);
        l.add(how);
        return l;
    }

    @Override
    public List<Component> getItemsForOMGraphicMenu(OMGraphic omg) {
        final OMGraphic chosen = omg;
        ArrayList<Component> l = new ArrayList<Component>();
        JMenuItem which = new JMenuItem("Which");
        which.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String classname = chosen.getClass().getName();
                InteractionLayer.this.fireRequestMessage("Which was chosen over " + classname.substring(classname.lastIndexOf(46) + 1));
            }
        });
        JMenuItem why = new JMenuItem("Why");
        why.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String classname = chosen.getClass().getName();
                InteractionLayer.this.fireRequestMessage("Why was chosen over " + classname.substring(classname.lastIndexOf(46) + 1));
            }
        });
        l.add(which);
        l.add(why);
        return l;
    }
}

