/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.event;

import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.event.OMEventHandlerAdapter;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.time.TimeBoundsHandler;
import com.bbn.openmap.time.TimeBoundsProvider;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEventHandler
extends OMEventHandlerAdapter
implements TimeBoundsProvider {
    protected TimeBounds timeBounds;
    protected List<TimeBoundsHandler> timeBoundsHandlers = new ArrayList<TimeBoundsHandler>();
    protected boolean active = true;

    public TestEventHandler() {
        this.timeBounds = new TimeBounds();
        this.createEvents();
    }

    protected void createEvents() {
        this.addEvent(new OMEvent("Object Source", "Event 1", System.currentTimeMillis()));
        this.addEvent(new OMEvent("Object Source", "Event 2", System.currentTimeMillis() + 1000L));
        this.addEvent(new OMEvent("Object Source", "Event 3", System.currentTimeMillis() + 2000L));
        this.addEvent(new OMEvent("Object Source", "Event 4", System.currentTimeMillis() + 3500L));
        this.addEvent(new OMEvent("Object Source", "Event 5", System.currentTimeMillis() + 5500L));
        this.addEvent(new OMEvent("Object Source", "Event 6", System.currentTimeMillis() + 10000L));
        this.addEvent(new OMEvent("Object Source", "Event 7", System.currentTimeMillis() + 20000L));
        this.addEvent(new OMEvent("Object Source", "Event 8", System.currentTimeMillis() + 25600L));
        this.addEvent(new OMEvent("Object Source", "Event 9", System.currentTimeMillis() + 45000L));
        this.addEvent(new OMEvent("Object Source", "Event 10", System.currentTimeMillis() + 60900L));
        this.callForTimeBoundsReset();
    }

    @Override
    public void addEvent(OMEvent event) {
        super.addEvent(event);
        this.timeBounds.addTimeToBounds(event.getTimeStamp());
    }

    @Override
    public List<OMEvent> getEventList(List filters) {
        if (this.active) {
            return this.events;
        }
        return new ArrayList<OMEvent>();
    }

    @Override
    public void addTimeBoundsHandler(TimeBoundsHandler tbh) {
        this.timeBoundsHandlers.add(tbh);
    }

    @Override
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Override
    public void handleTimeBounds(TimeBounds tb) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.callForTimeBoundsReset();
    }

    @Override
    public void removeTimeBoundsHandler(TimeBoundsHandler tbh) {
        this.timeBoundsHandlers.remove(tbh);
    }

    public void callForTimeBoundsReset() {
        for (TimeBoundsHandler tbh : this.timeBoundsHandlers) {
            tbh.resetTimeBounds();
        }
    }
}

