/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.etopo;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.layer.etopo.ETOPOLayer;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ETOPOJarLayer
extends ETOPOLayer {
    byte[] iv_buffer;
    int iv_bytesinbuffer;
    int iv_curptr;

    public ETOPOJarLayer() {
    }

    public ETOPOJarLayer(String pathToETOPODir) {
        super(pathToETOPODir);
    }

    protected void loadBuffer() {
        int resIdx = this.minuteSpacing / 5 - 1;
        if (resIdx < 0) {
            resIdx = 0;
        } else if (resIdx > 2) {
            resIdx = 2;
        }
        String fileName = this.path + etopoFileNames[resIdx];
        try {
            BufferedInputStream bis = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(fileName));
            this.bufferWidth = etopoWidths[resIdx];
            this.bufferHeight = etopoHeights[resIdx];
            int spacer = 1;
            switch (this.minuteSpacing) {
                case 2: {
                    spacer = 1 + this.spacer;
                    break;
                }
                case 5: {
                    spacer = 0 + this.spacer;
                    break;
                }
                default: {
                    spacer = 1 + this.spacer;
                }
            }
            int numberOfWords = (this.bufferWidth + spacer) * this.bufferHeight;
            this.dataBuffer = new short[numberOfWords];
            this.iv_buffer = new byte[2 * numberOfWords];
            this.iv_bytesinbuffer = bis.read(this.iv_buffer, 0, 2 * numberOfWords);
            this.iv_curptr = 0;
            for (int i = 0; i < this.bufferWidth * this.bufferHeight; ++i) {
                this.dataBuffer[i] = this.readShort();
            }
            bis.close();
            this.bufferWidth += spacer;
        }
        catch (FileNotFoundException e) {
            Debug.error("ETOPOLayer loadBuffer(): file " + fileName + " not found");
        }
        catch (IOException e) {
            Debug.error("ETOPOLayer loadBuffer(): File IO Error!\n" + e.toString());
        }
    }

    public short readShort() throws EOFException {
        if (this.iv_bytesinbuffer < 2) {
            throw new EOFException();
        }
        this.iv_curptr += 2;
        this.iv_bytesinbuffer -= 2;
        return MoreMath.BuildShort(this.iv_buffer, this.iv_curptr - 2, true);
    }

    protected OMRaster buildRaster() {
        OMRaster ret = null;
        Projection projection = this.getProjection();
        if (this.slopeMap != null) {
            int pixelColumns = projection.getWidth();
            int pixelRows = projection.getHeight();
            int[] colors = new int[pixelColumns * pixelRows];
            float yPixPerDataPt = (float)this.bufferHeight / 180.0f;
            float xPixPerDataPt = (float)this.bufferWidth / 360.0f;
            int sx = 0;
            int sy = 0;
            int ex = pixelColumns;
            int ey = pixelRows;
            if (projection instanceof CADRG) {
                Object ul = projection.getUpperLeft();
                Object lr = projection.getLowerRight();
                Point2D ulp = projection.forward((Point2D)ul);
                Point2D lrp = projection.forward((Point2D)lr);
                sx = (int)ulp.getX();
                ex = (int)lrp.getX();
                sy = (int)ulp.getY();
                ey = (int)lrp.getY();
            }
            Object center = projection.getCenter();
            LatLonPoint.Double llp = new LatLonPoint.Double();
            for (int y = sy; y < ey; ++y) {
                for (int x = sx; x < ex; ++x) {
                    projection.inverse(x, y, llp);
                    float lat = ((LatLonPoint)llp).getLatitude();
                    float lon = ((LatLonPoint)llp).getLongitude();
                    if ((double)lon < 0.0) {
                        lon = (float)((double)lon + 360.0);
                    }
                    int lat_idx = (int)((90.0 - (double)lat) * (double)yPixPerDataPt);
                    int lon_idx = (int)(lon * xPixPerDataPt);
                    float latWt = (90.0f - lat) * yPixPerDataPt - (float)lat_idx;
                    float lonWt = lon * xPixPerDataPt - (float)lon_idx;
                    int ofs = lon_idx + lat_idx * this.bufferWidth;
                    int ofsRight = ofs + 1;
                    int ofsDown = lat_idx + 1 < this.bufferHeight ? lon_idx + (1 + lat_idx) * this.bufferWidth : ofs;
                    int ofsDownRight = ofsDown + 1;
                    int idx = 0;
                    int gray = 0;
                    short el = 0;
                    byte sl = 0;
                    try {
                        try {
                            float ulwt = 1.0f - lonWt + 1.0f - latWt;
                            float urwt = lonWt + 1.0f - latWt;
                            float llwt = 1.0f - lonWt + latWt;
                            float lrwt = lonWt + latWt;
                            el = (short)((float)this.dataBuffer[ofs] * ulwt + (float)this.dataBuffer[ofsRight] * urwt + (float)this.dataBuffer[ofsDown] * llwt + (float)this.dataBuffer[ofsDownRight] * lrwt);
                            sl = (byte)((float)this.slopeMap[ofs] * ulwt + (float)this.slopeMap[ofsRight] * urwt + (float)this.slopeMap[ofsDown] * llwt + (float)this.slopeMap[ofsDownRight] * lrwt);
                            float exagFactor = 1.0f / (el > 0 ? 1.5f : 3.0f);
                            el = (short)((float)el * exagFactor);
                            sl = (byte)((float)sl * exagFactor);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            Debug.error(e.toString() + ":" + ofs + " limit=" + this.dataBuffer.length);
                        }
                        idx = y * pixelColumns + x;
                        Color pix = null;
                        if (this.viewType == 0) {
                            gray = (double)((LatLonPoint)llp).getLatitude() == ((Point2D)center).getY() && (double)((LatLonPoint)llp).getLongitude() == ((Point2D)center).getX() ? 0 : 127 + sl;
                            pix = new Color(gray, gray, gray, this.opaqueness);
                        } else if (this.viewType == 1) {
                            pix = (double)((LatLonPoint)llp).getLatitude() == ((Point2D)center).getY() && (double)((LatLonPoint)llp).getLongitude() == ((Point2D)center).getX() ? new Color(0, 0, 0, this.opaqueness) : this.getColor(el, sl);
                        }
                        if (pix == null) continue;
                        colors[idx] = pix.getRGB();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Debug.error(e.toString() + ":" + gray);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Debug.error(e.toString() + ":" + idx);
                    }
                }
            }
            ret = new OMRaster(0, 0, pixelColumns, pixelRows, colors);
        }
        return ret;
    }

    protected Color getColor(short elevation, byte slopeVal) {
        if (this.slopeColors == null) {
            System.out.println("loading colors");
            this.slopeColors = new Color[this.elevLimitCnt][8];
            for (int i = 0; i < this.elevLimitCnt; ++i) {
                Color base = new Color(this.redElev[i], this.greenElev[i], this.blueElev[i], this.opaqueness);
                for (int j = 4; j < 8; ++j) {
                    this.slopeColors[i][j] = j == 4 ? base : this.slopeColors[i][j - 1].brighter();
                }
                for (int k = 3; k >= 0; --k) {
                    this.slopeColors[i][k] = this.slopeColors[i][k + 1].darker();
                }
            }
        }
        int elIdx = this.getElevIndex(elevation);
        int slopeIdx = slopeVal + 127 >> 5;
        return this.slopeColors[elIdx][slopeIdx];
    }
}

