/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.editor;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.layer.DrawingToolLayer;
import com.bbn.openmap.layer.editor.EditorLayerMouseMode;
import com.bbn.openmap.layer.editor.EditorTool;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.util.Properties;
import javax.swing.JPanel;

public class EditorLayer
extends DrawingToolLayer
implements Tool {
    protected EditorTool editorTool = null;
    protected EditorLayerMouseMode elmm = null;
    public static final String EditorToolProperty = "editor";
    protected int orientation = 0;

    public void setProperties(String prefix, Properties props) {
        String realPrefix;
        String editorClassName;
        super.setProperties(prefix, props);
        if (this.editorTool == null && (editorClassName = props.getProperty((realPrefix = PropUtils.getScopedPropertyPrefix(prefix)) + EditorToolProperty)) != null) {
            Object[] objArgs = new Object[]{this};
            this.editorTool = (EditorTool)ComponentFactory.create(editorClassName, objArgs, prefix, props);
            if (this.editorTool == null) {
                this.editorTool = (EditorTool)ComponentFactory.create(editorClassName, prefix, props);
            }
            if (this.editorTool == null) {
                String additionalInfo = ".";
                if (editorClassName != null) {
                    additionalInfo = ", although an editor tool class (" + editorClassName + ") was defined.";
                }
                Debug.error(this.getName() + " doesn't have a EditorTool defined" + additionalInfo);
            }
        }
    }

    public EditorLayerMouseMode getMouseMode() {
        if (this.elmm == null) {
            String ln = this.getName();
            if (ln == null) {
                ln = this.getClass().getName() + System.currentTimeMillis();
                return new EditorLayerMouseMode(ln.intern(), true);
            }
            this.elmm = new EditorLayerMouseMode(ln.intern(), true);
        }
        return this.elmm;
    }

    public void setName(String name) {
        super.setName(name);
        this.elmm = null;
        this.setMouseModeIDsForEvents(this.getMouseModeIDsForEvents());
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        super.drawingComplete(omg, action);
        if (this.editorTool != null) {
            this.editorTool.drawingComplete(omg, action);
        }
    }

    public void findAndInit(Object someObj) {
        if (!(someObj instanceof DrawingTool)) {
            super.findAndInit(someObj);
        }
        if (this.editorTool != null) {
            this.editorTool.findAndInit(someObj);
        }
        if (someObj instanceof InformationDelegator || someObj instanceof SelectMouseMode) {
            this.getMouseMode().findAndInit(someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (this.editorTool != null) {
            this.editorTool.findAndUndo(someObj);
        }
        if (someObj instanceof InformationDelegator || someObj instanceof SelectMouseMode) {
            this.getMouseMode().findAndUndo(someObj);
        }
    }

    public void dispose() {
        if (this.editorTool != null) {
            this.editorTool.dispose();
        }
        super.dispose();
    }

    public void setMouseModeIDsForEvents(String[] modes) {
        EditorLayerMouseMode elmm = this.getMouseMode();
        String[] newModes = new String[modes.length + 1];
        System.arraycopy(modes, 0, newModes, 0, modes.length);
        newModes[modes.length] = elmm.getID();
        super.setMouseModeIDsForEvents(newModes);
    }

    public String[] getMouseModeIDsForEvents() {
        String[] modes = super.getMouseModeIDsForEvents();
        if (modes == null) {
            this.setMouseModeIDsForEvents(new String[0]);
            return super.getMouseModeIDsForEvents();
        }
        return modes;
    }

    public MapMouseInterpreter getMouseEventInterpreter() {
        return this.mouseEventInterpreter;
    }

    public EditorTool getEditorTool() {
        return this.editorTool;
    }

    public void setEditorTool(EditorTool editorTool) {
        this.editorTool = editorTool;
    }

    public void setVisible(boolean show) {
        if (this.editorTool != null) {
            this.editorTool.setVisible(show);
        }
        super.setVisible(show);
    }

    public Container getFace() {
        if (this.editorTool != null) {
            return this.editorTool.getFace();
        }
        return new JPanel();
    }

    public String getKey() {
        String tmpKey = this.getPropertyPrefix();
        if (tmpKey == null && (tmpKey = this.getName()) == null) {
            tmpKey = this.getClass().getName();
        }
        return tmpKey;
    }

    public void setKey(String aKey) {
        this.setPropertyPrefix(aKey);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    protected void creatingOMGraphic(OMGraphic newOMG) {
    }
}

