/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.beanbox;

import com.bbn.openmap.layer.beanbox.SimpleBeanContainer;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.beanbox.BeanLayoutManager;
import com.bbn.openmap.util.Debug;
import java.util.Vector;

public class WallFormationLayout
extends BeanLayoutManager {
    private float separationInNM;
    private float bearingInDeg;

    public WallFormationLayout() {
        this(35.0f, 90.0f, null);
    }

    public WallFormationLayout(float sep, float bearing, SimpleBeanContainer c) {
        this.separationInNM = sep;
        this.bearingInDeg = bearing;
        this._container = c;
    }

    public float getSeparationInNM() {
        return this.separationInNM;
    }

    public void setSeparationInNM(float sep) {
        this.separationInNM = sep;
        this.layoutContainer();
    }

    public float getBearingInDeg() {
        return this.bearingInDeg;
    }

    public void setBearingInDeg(float bearing) {
        if (bearing < 0.0f) {
            bearing = 360.0f - bearing;
        }
        this.bearingInDeg = bearing % 360.0f;
        this.layoutContainer();
    }

    public void layoutContainer() {
        if (this._container == null) {
            return;
        }
        SimpleBeanContainer container = (SimpleBeanContainer)this._container;
        Vector contents = this._container.getContents();
        if (contents == null || contents.isEmpty()) {
            return;
        }
        LatLonPoint.Float midllp = new LatLonPoint.Float(container.getLatitude(), container.getLongitude());
        LatLonPoint[] llps = new LatLonPoint[contents.size()];
        if (contents.size() == 1) {
            llps[0] = midllp;
        } else {
            LatLonPoint cornerllp1;
            float angle1Deg = this.bearingInDeg - 90.0f;
            float angle1Rad = (float)Math.toRadians(angle1Deg);
            float angle2Deg = this.bearingInDeg + 90.0f;
            float angle2Rad = (float)Math.toRadians(angle2Deg);
            int numBeans = contents.size();
            float spanNM = (float)(numBeans - 1) * this.separationInNM;
            llps[0] = cornerllp1 = midllp.getPoint((double)Length.NM.toRadians(spanNM / 2.0f), (double)angle1Rad);
            for (int i = 1; i < contents.size(); ++i) {
                llps[i] = GreatCircle.sphericalBetween((float)cornerllp1.getRadLat(), (float)cornerllp1.getRadLon(), Length.NM.toRadians(this.separationInNM) * (float)i, angle2Rad);
            }
        }
        for (int i = 0; i < contents.size(); ++i) {
            Long id = (Long)contents.get(i);
            Debug.error("Here in WallFormationLayout, trying to get layer SimpleBeanObjects");
        }
    }
}

