/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.beanbox;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.beanbox.SimpleBeanContainer;
import com.bbn.openmap.layer.beanbox.SimpleBeanLayer;
import com.bbn.openmap.layer.beanbox.SimpleBeanObject;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.beanbox.BeanBox;
import com.bbn.openmap.tools.beanbox.BeanContainer;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.BeanInfo;
import java.util.Vector;

public class SimpleBeanBox
extends BeanBox
implements MapMouseListener {
    private SimpleBeanLayer layer;
    private static SimpleBeanBox thisBeanBox = null;

    public SimpleBeanBox(SimpleBeanLayer l) {
        this.layer = l;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{"Gestures"};
    }

    public boolean mousePressed(MouseEvent evt) {
        return true;
    }

    public boolean mouseReleased(MouseEvent evt) {
        return true;
    }

    public boolean mouseClicked(MouseEvent evt) {
        return true;
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public boolean mouseDragged(MouseEvent evt) {
        return true;
    }

    public boolean mouseMoved(MouseEvent evt) {
        return true;
    }

    public void mouseMoved() {
    }

    public void addBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject");
        }
        this.layer.addObject((SimpleBeanObject)bean);
    }

    public void removeBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject");
        }
        this.layer.removeObject(((SimpleBeanObject)bean).getId());
    }

    public boolean containsBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        return this.layer.getObject(((SimpleBeanObject)bean).getId()) != null;
    }

    public void setBeanProperties(Object bean, BeanInfo beanInfo, Point location) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        Image img = beanInfo.getIcon(2);
        obj.setGraphicImage(img);
        Object llp = this.layer.getProjection().inverse(location.x, location.y);
        obj.setLatitude((float)((Point2D)llp).getY());
        obj.setLongitude((float)((Point2D)llp).getX());
    }

    Vector getAllContainers() {
        Vector containers = new Vector();
        Vector list = this.layer.getObjects();
        if (list == null || list.isEmpty()) {
            return containers;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof BeanContainer)) continue;
            containers.add(obj);
        }
        return containers;
    }

    public BeanContainer findEnclosingContainer(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            return null;
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        float objLat = obj.getLatitude();
        float objLon = obj.getLongitude();
        LatLonPoint.Float llp = new LatLonPoint.Float(objLat, objLon);
        return this.findEnclosingContainer(llp);
    }

    public SimpleBeanContainer findEnclosingContainer(LatLonPoint llp) {
        Vector containers = this.getAllContainers();
        for (int i = 0; i < containers.size(); ++i) {
            SimpleBeanContainer container = (SimpleBeanContainer)containers.get(i);
            if (!this.encloses(container, llp)) continue;
            return container;
        }
        return null;
    }

    boolean encloses(SimpleBeanContainer container, Point2D llp) {
        float topLat = container.getTopLatitude();
        float leftLon = container.getLeftLongitude();
        float botLat = container.getBottomLatitude();
        float rightLon = container.getRightLongitude();
        float lat = (float)llp.getY();
        float lon = (float)llp.getX();
        if (lon > rightLon || lon < leftLon) {
            return false;
        }
        return !(lat > topLat) && !(lat < botLat);
    }

    BeanContainer findContainerBean(Point pointOnMap) {
        if (this.layer != null && this.layer.getProjection() != null) {
            Object llp = this.layer.getProjection().inverse(pointOnMap.x, pointOnMap.y);
            return this.findEnclosingContainer(llp);
        }
        return null;
    }

    SimpleBeanObject findNonContainerBean(Point pointOnMap) {
        Vector list = this.layer.getObjects();
        double minSep = Double.MAX_VALUE;
        SimpleBeanObject closest = null;
        for (int i = 0; i < list.size(); ++i) {
            Point2D p2;
            double sep;
            Object o = list.get(i);
            SimpleBeanObject obj = (SimpleBeanObject)o;
            if (obj instanceof SimpleBeanContainer || !((sep = this.almostEquals(pointOnMap, p2 = this.layer.getProjection().forward(new LatLonPoint.Float(obj.getLatitude(), obj.getLongitude())), 20.0)) < minSep)) continue;
            minSep = sep;
            closest = obj;
        }
        return closest;
    }

    public Object getBeanAtLocation(Point pointOnMap) {
        SimpleBeanObject obj = this.findNonContainerBean(pointOnMap);
        if (obj != null) {
            return obj;
        }
        BeanContainer container = this.findContainerBean(pointOnMap);
        if (container != null) {
            return container;
        }
        return null;
    }

    double almostEquals(Point2D p1, Point2D p2, double tol) {
        double sepY;
        double sepX = p1.getX() - p2.getX();
        double sep = Math.sqrt(sepX * sepX + (sepY = p1.getY() - p2.getY()) * sepY);
        if (sep <= tol) {
            return sep;
        }
        return Double.MAX_VALUE;
    }

    public void relocateBean(Object bean, BeanInfo beanInfo, Point newLocation) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        Object llp = this.layer.getProjection().inverse(newLocation.x, newLocation.y);
        this.relocateSimpleBeanObject(obj, (Point2D)llp);
        this.layer.updateGraphics();
    }

    void relocateSimpleBeanObject(SimpleBeanObject obj, Point2D newllp) {
        SimpleBeanContainer oldContainer = null;
        if (!(obj instanceof SimpleBeanContainer)) {
            oldContainer = (SimpleBeanContainer)this.findEnclosingContainer(obj);
        }
        if (oldContainer != null) {
            oldContainer.remove(obj);
        }
        obj.setLatitude((float)newllp.getY());
        obj.setLongitude((float)newllp.getX());
        if (obj instanceof SimpleBeanContainer) {
            ((SimpleBeanContainer)obj).validate();
        }
        SimpleBeanContainer newContainer = null;
        if (!(obj instanceof SimpleBeanContainer)) {
            newContainer = (SimpleBeanContainer)this.findEnclosingContainer(obj);
        }
        if (newContainer != null) {
            newContainer.add(obj);
        }
    }

    public void beanChanged(Object bean, String changedPropertyName) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        this.layer.updateObject(obj);
    }

    protected Image getDragImage(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        OMGraphic graphic = this.layer.getGraphic(obj.getId());
        if (graphic instanceof OMRasterObject) {
            return ((OMRasterObject)graphic).getImage();
        }
        return super.getDragImage(bean);
    }
}

