/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.MapBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class MapBeanPrinter
implements Printable {
    private MapBean MapBeanToBePrinted;
    private Dimension MapSize;

    public static void printMap(MapBean mapBean) {
        new MapBeanPrinter(mapBean).print();
    }

    public MapBeanPrinter(MapBean mapBean) {
        this.MapSize = mapBean.getSize();
        this.MapBeanToBePrinted = mapBean;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        double frameHeight = this.MapSize.height;
        double frameWidth = this.MapSize.width;
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double xScale = pageWidth / frameWidth;
        double yScale = pageHeight / frameHeight;
        double scale = xScale;
        if (yScale < xScale) {
            scale = yScale;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX() - 1.0, pageFormat.getImageableY() - 1.0);
        g2d.scale(scale, scale);
        MapBeanPrinter.disableDoubleBuffering(this.MapBeanToBePrinted);
        this.MapBeanToBePrinted.paint(g2d);
        MapBeanPrinter.enableDoubleBuffering(this.MapBeanToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

