/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class ImageIOFormatter
extends AbstractImageFormatter {
    protected String formatName;

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public byte[] formatImage(BufferedImage bi) {
        try {
            ByteArrayOutputStream byo = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, this.getFormatName(), byo);
            return byo.toByteArray();
        }
        catch (IOException ioe) {
            Debug.error("ImageIOFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public Graphics getGraphics(int width, int height) {
        return this.getGraphics(width, height, 2);
    }
}

