/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.gui.menu.CoordsMenuItem;
import com.bbn.openmap.gui.menu.ProjectionMenu;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class NavigateMenu
extends AbstractOpenMapMenu
implements ActionListener {
    public static final String defaultText = "Navigate";
    public static final String defaultMnemonic = "N";
    protected ZoomSupport zoomSupport = new ZoomSupport(this);
    public static final transient String zoomIn2Cmd = "zoomIn2Cmd";
    public static final transient String zoomIn4Cmd = "zoomIn4Cmd";
    public static final transient String zoomOut2Cmd = "zoomOut2Cmd";
    public static final transient String zoomOut4Cmd = "zoomOut4Cmd";

    public NavigateMenu() {
        this.setText(this.i18n.get(this, "navigate", defaultText));
        this.add(new CoordsMenuItem());
        JMenu submenu = (JMenu)this.add(new JMenu(this.i18n.get(this, "zoomIn", "Zoom In")));
        JMenuItem mi = submenu.add(new JMenuItem(this.i18n.get(this, "zoomIn2X", "2X")));
        mi.setActionCommand(zoomIn2Cmd);
        mi.addActionListener(this);
        mi = submenu.add(new JMenuItem(this.i18n.get(this, "zoomIn4X", "4X")));
        mi.setActionCommand(zoomIn4Cmd);
        mi.addActionListener(this);
        submenu = (JMenu)this.add(new JMenu(this.i18n.get(this, "zoomOut", "Zoom Out")));
        mi = submenu.add(new JMenuItem(this.i18n.get(this, "zoomOut2X", "2X")));
        mi.setActionCommand(zoomOut2Cmd);
        mi.addActionListener(this);
        mi = submenu.add(new JMenuItem(this.i18n.get(this, "zoomOut4X", "4X")));
        mi.setActionCommand(zoomOut4Cmd);
        mi.addActionListener(this);
        this.add(new ProjectionMenu());
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        Debug.message("navigatemenu", "NavigateMenu.actionPerformed(): " + command);
        if (command.equals(zoomIn2Cmd)) {
            this.fireZoom(301, 0.5f);
        } else if (command.equals(zoomIn4Cmd)) {
            this.fireZoom(301, 0.25f);
        } else if (command.equals(zoomOut2Cmd)) {
            this.fireZoom(301, 2.0f);
        } else if (command.equals(zoomOut4Cmd)) {
            this.fireZoom(301, 4.0f);
        }
    }

    public synchronized void addZoomListener(ZoomListener l) {
        this.zoomSupport.add(l);
    }

    public synchronized void removeZoomListener(ZoomListener l) {
        this.zoomSupport.remove(l);
    }

    public void fireZoom(int zoomType, float amount) {
        this.zoomSupport.fireZoom(zoomType, amount);
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapBean) {
            this.addZoomListener((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof MapBean) {
            this.removeZoomListener((MapBean)someObj);
        }
    }
}

