/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.JSplitPane;

public class HotwashPanel
extends OMComponentPanel {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.HotwashPanel");
    protected JSplitPane leftSlider;
    protected JSplitPane rightSlider;
    protected JSplitPane bottomSlider;

    public HotwashPanel() {
        this.create();
    }

    public void create() {
        WindowSupport.setDefaultWindowSupportDisplayType(WindowSupport.Dlg.class);
        this.setLayout(this.createLayoutManager());
        this.leftSlider = new JSplitPane();
        this.leftSlider.setBorder(null);
        this.leftSlider.setResizeWeight(0.0);
        this.leftSlider.setOneTouchExpandable(true);
        this.rightSlider = new JSplitPane();
        this.rightSlider.setBorder(null);
        this.rightSlider.setResizeWeight(1.0);
        this.rightSlider.setOneTouchExpandable(true);
        this.rightSlider.setLeftComponent(this.leftSlider);
        this.rightSlider.setRightComponent(null);
        super.add((Component)this.rightSlider, "Center");
    }

    public Component add(Component comp, String location) {
        if ("East".equals(location)) {
            this.rightSlider.setRightComponent(comp);
        } else if ("West".equals(location)) {
            this.leftSlider.setLeftComponent(comp);
        } else if ("Center".equals(location)) {
            if (this.bottomSlider != null) {
                this.bottomSlider.setTopComponent(comp);
            } else {
                this.leftSlider.setRightComponent(comp);
            }
        } else if ("North".equals(location) && this.bottomSlider != null) {
            this.bottomSlider.setBottomComponent(comp);
        } else {
            super.add(comp, location);
        }
        return comp;
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapPanelChild && someObj instanceof Component) {
            boolean makeMyChild;
            String parentName = ((MapPanelChild)someObj).getParentName();
            String myName = this.getPropertyPrefix();
            boolean bl = makeMyChild = myName != null && parentName != null && myName.equalsIgnoreCase(parentName) || myName == null && parentName == null;
            if (makeMyChild) {
                logger.fine("HotwashPanel: adding " + someObj.getClass().getName() + " to " + ((MapPanelChild)someObj).getPreferredLocation());
                MapPanelChild mpc = (MapPanelChild)someObj;
                this.addMapPanelChild(mpc);
                this.revalidate();
            }
        }
        if (someObj instanceof MapPanel) {
            this.add((Component)someObj, "Center");
        }
    }

    protected void addMapPanelChild(MapPanelChild mpc) {
        this.add((Component)((Object)mpc), mpc.getPreferredLocation());
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapPanelChild && someObj instanceof Component) {
            if (Debug.debugging("basic")) {
                Debug.output("HotwashPanel: removing " + someObj.getClass().getName());
            }
            this.remove((Component)someObj);
            this.invalidate();
        }
    }

    public JSplitPane getBottomSlider() {
        return this.bottomSlider;
    }

    public JSplitPane getLeftSlider() {
        return this.leftSlider;
    }

    public JSplitPane getRightSlider() {
        return this.rightSlider;
    }
}

