/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.proj.Projection;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionSupport
extends ListenerSupport<ProjectionListener> {
    static Logger logger = Logger.getLogger("com.bbn.openmap.event.ProjectionSupport");
    private static final long serialVersionUID = 1L;
    protected ProjectionChangeNotifier pcNotifier;
    protected boolean useNotifier;

    public ProjectionSupport(boolean useNotifier) {
        this(null, useNotifier);
    }

    public ProjectionSupport(Object aSource, boolean useNotifier) {
        super(aSource);
        this.useNotifier = useNotifier;
    }

    public void fireProjectionChanged(Projection proj) {
        if (proj == null || this.isEmpty()) {
            return;
        }
        if (this.useNotifier && this.pcNotifier == null) {
            this.pcNotifier = new ProjectionChangeNotifier();
            this.pcNotifier.start();
        }
        ProjectionEvent event = new ProjectionEvent(this.getSource(), proj);
        if (this.pcNotifier != null) {
            this.pcNotifier.fireProjectionEvent(event);
        } else {
            for (ProjectionListener listener : this) {
                listener.projectionChanged(event);
            }
        }
    }

    public void dispose() {
        super.clear();
        if (this.pcNotifier != null) {
            this.pcNotifier.setTerminated(true);
            this.pcNotifier.fireProjectionEvent(null);
            this.pcNotifier.interrupt();
            this.pcNotifier = null;
        }
    }

    protected class ProjectionChangeNotifier
    extends Thread {
        private final Object lock = new Object();
        protected ProjectionEvent projEvent;
        protected ProjectionEvent nextEvent;
        protected boolean terminated = false;

        public ProjectionChangeNotifier() {
            this.setName("ProjectionSupportThread " + this.getName());
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }

        protected boolean isEventInProgress() {
            return this.projEvent != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireProjectionEvent(ProjectionEvent event) {
            Object object = this.lock;
            synchronized (object) {
                this.nextEvent = event;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.terminated) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.nextEvent != null) {
                        this.projEvent = this.nextEvent;
                        this.nextEvent = null;
                    }
                }
                if (this.projEvent != null && !ProjectionSupport.this.isEmpty()) {
                    try {
                        ListIterator li = ProjectionSupport.this.listIterator();
                        while (li.hasPrevious()) {
                            ProjectionListener listener = (ProjectionListener)li.previous();
                            if (this.nextEvent == null) {
                                try {
                                    Object object2 = this.lock;
                                    synchronized (object2) {
                                        listener.projectionChanged(this.projEvent);
                                        continue;
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger.isLoggable(Level.FINE)) continue;
                                    logger.info("ProjectionListener not handling projection well: " + listener.getClass().getName() + " : " + e.getClass().getName() + " : " + e.getMessage());
                                    e.printStackTrace();
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.fine("caught exception: " + e.getClass().getName() + " : " + e.getMessage());
                    }
                    object = this.lock;
                    synchronized (object) {
                        this.projEvent = null;
                        continue;
                    }
                }
                try {
                    object = this.lock;
                    synchronized (object) {
                        while (this.nextEvent == null) {
                            this.lock.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            logger.fine("Projection notifier thread " + this.getName() + " done running");
        }
    }
}

