/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class NavMouseMode2
extends NavMouseMode {
    public NavMouseMode2() {
        this(true);
    }

    public NavMouseMode2(boolean shouldConsumeEvents) {
        super(shouldConsumeEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode2.mouseReleased()");
        }
        Object obj = e.getSource();
        Point firstPoint = this.point1;
        Point secondPoint = this.point2;
        MapBean map = this.theMap;
        if (map != obj || !this.autoZoom || firstPoint == null || secondPoint == null) {
            return;
        }
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        NavMouseMode2 navMouseMode2 = this;
        synchronized (navMouseMode2) {
            secondPoint = this.point2 = this.getRatioPoint(map, firstPoint, e.getPoint());
            int dx = Math.abs(secondPoint.x - firstPoint.x);
            int dy = Math.abs(secondPoint.y - firstPoint.y);
            if (dx < 5 || dy < 5) {
                if (dx < 5 && dy < 5) {
                    Point2D llp = map.getCoordinates(e);
                    boolean shift = e.isShiftDown();
                    boolean control = e.isControlDown();
                    if (control) {
                        if (shift) {
                            p.setScale(p.getScale() * 2.0f);
                        } else {
                            p.setScale(p.getScale() / 2.0f);
                        }
                    }
                    this.cleanUp();
                    p.setCenter(llp);
                    map.setProjection(p);
                }
                return;
            }
            dx = Math.abs(secondPoint.x - firstPoint.x);
            dy = Math.abs(secondPoint.y - firstPoint.y);
            Point cornerPoint1 = new Point(secondPoint.x < firstPoint.x ? secondPoint.x : firstPoint.x, secondPoint.y < firstPoint.y ? secondPoint.y : firstPoint.y);
            Point cornerPoint2 = new Point(cornerPoint1.x + 2 * dx, cornerPoint1.y + 2 * dy);
            float newScale = ProjMath.getScale(cornerPoint1, cornerPoint2, projection);
            Point2D center = map.inverse(firstPoint.x, firstPoint.y, null);
            p.setScale(newScale);
            p.setCenter(center);
            this.cleanUp();
            map.setProjection(p);
        }
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            Rectangle2D.Double rect1 = new Rectangle2D.Double(pt1.x - width, pt1.y - height, width * 2, height * 2);
            Rectangle2D.Double rect2 = new Rectangle2D.Double(pt1.x - 1, pt1.y - 1, 3.0, 3.0);
            if (this.theMap != null) {
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect1));
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect2));
            }
        }
    }
}

