/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFConstants;
import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFFieldDefinition;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfieldDefinition;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class DDFRecord
implements DDFConstants {
    protected DDFModule poModule;
    protected boolean nReuseHeader;
    protected int nFieldOffset;
    protected int nDataSize;
    protected byte[] pachData;
    protected int nFieldCount;
    protected Vector paoFields;
    protected boolean bIsClone = false;

    public DDFRecord(DDFModule poModuleIn) {
        this.poModule = poModuleIn;
        this.nReuseHeader = false;
        this.nFieldOffset = -1;
        this.nDataSize = 0;
        this.pachData = null;
        this.nFieldCount = 0;
        this.paoFields = null;
        this.bIsClone = false;
    }

    public int getFieldCount() {
        return this.nFieldCount;
    }

    public int getDataSize() {
        return this.nDataSize;
    }

    public byte[] getData() {
        return this.pachData;
    }

    public DDFModule getModule() {
        return this.poModule;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DDFRecord:\n");
        buf.append("    ReuseHeader = ").append(this.nReuseHeader).append("\n");
        buf.append("    DataSize = ").append(this.nDataSize).append("\n");
        if (this.paoFields != null) {
            Iterator it = this.paoFields.iterator();
            while (it.hasNext()) {
                buf.append((DDFField)it.next());
            }
        }
        return buf.toString();
    }

    protected boolean read() {
        if (!this.nReuseHeader) {
            Debug.message("iso8211", "DDFRecord reusing header, calling readHeader()");
            return this.readHeader();
        }
        byte[] tempData = new byte[this.nDataSize - this.nFieldOffset];
        int nReadBytes = this.poModule.read(tempData, 0, tempData.length);
        System.arraycopy(this.pachData, this.nFieldOffset, tempData, 0, tempData.length);
        if (nReadBytes != this.nDataSize - this.nFieldOffset && nReadBytes == -1) {
            return false;
        }
        if (nReadBytes != this.nDataSize - this.nFieldOffset) {
            Debug.error("DDFRecord: Data record is short on DDF file.");
            return false;
        }
        return true;
    }

    public void clear() {
        if (this.paoFields != null) {
            this.paoFields = null;
        }
        this.paoFields = null;
        this.nFieldCount = 0;
        this.pachData = null;
        this.nDataSize = 0;
        this.nReuseHeader = false;
    }

    protected boolean readHeader() {
        int i;
        int _fieldAreaStart;
        int _recLength;
        this.clear();
        byte[] achLeader = new byte[24];
        int nReadBytes = this.poModule.read(achLeader, 0, 24);
        if (nReadBytes == -1) {
            return false;
        }
        if (nReadBytes != 24) {
            Debug.error("DDFRecord.readHeader(): Leader is short on DDF file.");
            return false;
        }
        try {
            String recLength = new String(achLeader, 0, 5);
            String fieldAreaStart = new String(achLeader, 12, 5);
            _recLength = this.controlValidFileLength(Integer.valueOf(recLength));
            _fieldAreaStart = Integer.valueOf(fieldAreaStart);
        }
        catch (NumberFormatException nfe) {
            if (Debug.debugging("iso8211")) {
                Debug.output("Finished reading headers");
            }
            if (Debug.debugging("iso8211detail")) {
                Debug.error("DDFRecord.readHeader(): " + nfe.getMessage());
                nfe.printStackTrace();
            }
            return false;
        }
        byte _leaderIden = achLeader[6];
        int _sizeFieldLength = achLeader[20] - 48;
        int _sizeFieldPos = achLeader[21] - 48;
        int _sizeFieldTag = achLeader[23] - 48;
        if (_leaderIden == 82) {
            this.nReuseHeader = true;
        }
        this.nFieldOffset = _fieldAreaStart - 24;
        if (Debug.debugging("iso8211")) {
            Debug.output("\trecord length [0,5] = " + _recLength);
            Debug.output("\tfield area start [12,5]= " + _fieldAreaStart);
            Debug.output("\tleader id [6] = " + (char)_leaderIden + ", reuse header = " + this.nReuseHeader);
            Debug.output("\tfield length [20] = " + _sizeFieldLength);
            Debug.output("\tfield position [21] = " + _sizeFieldPos);
            Debug.output("\tfield tag [23] = " + _sizeFieldTag);
        }
        boolean readSubfields = false;
        if (_recLength == 0) {
            this.nDataSize = _fieldAreaStart - 24;
        } else {
            if (_recLength < 24 || _recLength > 100000000 || _fieldAreaStart < 24 || _fieldAreaStart > 100000) {
                Debug.error("DDFRecord: Data record appears to be corrupt on DDF file.\n -- ensure that the files were uncompressed without modifying\n carriage return/linefeeds (by default WINZIP does this).");
                return false;
            }
            this.nDataSize = _recLength - 24;
            readSubfields = true;
        }
        this.pachData = new byte[this.nDataSize];
        if (this.poModule.read(this.pachData, 0, this.nDataSize) != this.nDataSize) {
            Debug.error("DDFRecord: Data record is short on DDF file.");
            return false;
        }
        int nFieldEntryWidth = _sizeFieldLength + _sizeFieldPos + _sizeFieldTag;
        this.nFieldCount = 0;
        for (i = 0; i < this.nDataSize && this.pachData[i] != 30; i += nFieldEntryWidth) {
            ++this.nFieldCount;
        }
        this.paoFields = new Vector(this.nFieldCount);
        for (i = 0; i < this.nFieldCount; ++i) {
            int nEntryOffset = i * nFieldEntryWidth;
            String szTag = new String(this.pachData, nEntryOffset, _sizeFieldTag);
            int nFieldLength = Integer.valueOf(new String(this.pachData, nEntryOffset += _sizeFieldTag, _sizeFieldLength));
            int nFieldPos = Integer.valueOf(new String(this.pachData, nEntryOffset += _sizeFieldLength, _sizeFieldPos));
            DDFFieldDefinition poFieldDefn = this.poModule.findFieldDefn(szTag);
            if (poFieldDefn == null) {
                Debug.error("DDFRecord: Undefined field " + szTag + " encountered in data record.");
                return false;
            }
            DDFField ddff = null;
            if (readSubfields) {
                byte[] tempData = new byte[nFieldLength];
                System.arraycopy(this.pachData, _fieldAreaStart + nFieldPos - 24, tempData, 0, tempData.length);
                ddff = new DDFField(poFieldDefn, tempData, readSubfields);
            } else {
                ddff = new DDFField(poFieldDefn, nFieldPos, nFieldLength);
                ddff.setHeaderOffset(this.poModule._recLength + _fieldAreaStart);
            }
            this.paoFields.add(ddff);
        }
        return true;
    }

    private int controlValidFileLength(int fileLength) {
        return fileLength == 0 ? this.computeAwaitingFileLength(fileLength) : fileLength;
    }

    private int computeAwaitingFileLength(int fileLength) {
        int _awaiting_file_length = 0;
        try {
            int _src_file_length = (int)this.poModule.getFileLength();
            int _current_record_length = this.poModule.getRecordLength();
            _awaiting_file_length = _src_file_length - (_current_record_length + 53);
        }
        catch (IOException e) {
            e.printStackTrace();
            return fileLength;
        }
        return _awaiting_file_length;
    }

    public DDFField findField(String pszName, int iFieldIndex) {
        for (DDFField ddff : this.paoFields) {
            if (!pszName.equalsIgnoreCase(ddff.getFieldDefn().getName())) continue;
            if (iFieldIndex == 0) {
                return ddff;
            }
            --iFieldIndex;
        }
        return null;
    }

    public DDFField getField(int i) {
        try {
            return (DDFField)this.paoFields.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public Iterator iterator() {
        if (this.paoFields != null) {
            return this.paoFields.iterator();
        }
        return null;
    }

    public int getIntSubfield(String pszField, int iFieldIndex, String pszSubfield, int iSubfieldIndex) {
        DDFField poField = this.findField(pszField, iFieldIndex);
        if (poField == null) {
            return 0;
        }
        DDFSubfieldDefinition poSFDefn = poField.getFieldDefn().findSubfieldDefn(pszSubfield);
        if (poSFDefn == null) {
            return 0;
        }
        MutableInt nBytesRemaining = new MutableInt();
        byte[] pachData = poField.getSubfieldData(poSFDefn, nBytesRemaining, iSubfieldIndex);
        return poSFDefn.extractIntData(pachData, nBytesRemaining.value, null);
    }

    public double getFloatSubfield(String pszField, int iFieldIndex, String pszSubfield, int iSubfieldIndex) {
        DDFField poField = this.findField(pszField, iFieldIndex);
        if (poField == null) {
            return 0.0;
        }
        DDFSubfieldDefinition poSFDefn = poField.getFieldDefn().findSubfieldDefn(pszSubfield);
        if (poSFDefn == null) {
            return 0.0;
        }
        MutableInt nBytesRemaining = new MutableInt();
        byte[] pachData = poField.getSubfieldData(poSFDefn, nBytesRemaining, iSubfieldIndex);
        return poSFDefn.extractFloatData(pachData, nBytesRemaining.value, null);
    }

    String getStringSubfield(String pszField, int iFieldIndex, String pszSubfield, int iSubfieldIndex) {
        DDFField poField = this.findField(pszField, iFieldIndex);
        if (poField == null) {
            return null;
        }
        DDFSubfieldDefinition poSFDefn = poField.getFieldDefn().findSubfieldDefn(pszSubfield);
        if (poSFDefn == null) {
            return null;
        }
        MutableInt nBytesRemaining = new MutableInt();
        byte[] pachData = poField.getSubfieldData(poSFDefn, nBytesRemaining, iSubfieldIndex);
        return poSFDefn.extractStringData(pachData, nBytesRemaining.value, null);
    }
}

