/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.dted.DTEDDirectoryHandler;
import com.bbn.openmap.dataAccess.dted.DTEDFrame;
import com.bbn.openmap.dataAccess.dted.DTEDNameTranslator;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.geom.Point2D;
import java.util.Properties;
import java.util.Vector;

public class DTEDFrameCache
extends CacheHandler
implements PropertyConsumer {
    public static final int NO_DATA = -32767;
    public static final String DTEDDirectoryHandlerProperty = "directoryHandlers";
    public static final String DTEDFrameCacheSizeProperty = "cacheSize";
    public int DEFAULT_CACHE_SIZE = 20;
    protected String propertyPrefix = null;
    protected Vector directories = new Vector();
    protected int highestResLevel = 2;

    public DTEDFrameCache() {
    }

    public DTEDFrameCache(int max_size) {
        super(max_size);
    }

    public void addDTEDDirectoryHandler(DTEDDirectoryHandler handler) {
        this.directories.add(handler);
    }

    public void removeDTEDDirectoryHandler(DTEDDirectoryHandler handler) {
        this.directories.remove(handler);
    }

    public Vector getDTEDDirectoryHandlers() {
        return this.directories;
    }

    public void setDTEDDirectoryHandlers(Vector handlers) {
        this.directories = handlers;
    }

    public String findFileName(double lat, double lon, int level) {
        if (this.directories != null) {
            for (DTEDDirectoryHandler ddh : this.directories) {
                DTEDNameTranslator dnt = ddh.getTranslator();
                dnt.set(lat, lon, level);
                String dtedFileName = dnt.getName();
                if (Debug.debugging("dtedfile")) {
                    Debug.output("DTEDFrameCache translator returns " + dtedFileName + " for " + lat + ", " + lon + ", level " + level);
                }
                if (!BinaryFile.exists(dtedFileName)) continue;
                return dtedFileName;
            }
        }
        return null;
    }

    public DTEDFrame get(double lat, double lon, int level) {
        String name = this.findFileName(lat, lon, level);
        if (name != null) {
            if (Debug.debugging("dtedfile")) {
                Debug.output("DTEDFrameCache: returning " + name + " for " + lat + ", " + lon + ", level " + level);
            }
            return (DTEDFrame)this.get(name);
        }
        if (Debug.debugging("dtedfile")) {
            Debug.output("DTEDFrameCache: couldn't find frame for " + lat + ", " + lon + ", level " + level);
        }
        return null;
    }

    public CacheObject load(Object key) {
        if (key != null) {
            String dtedFramePath = key.toString();
            DTEDFrame frame = new DTEDFrame(dtedFramePath, true);
            if (frame.frame_is_valid) {
                return new DTEDCacheObject(dtedFramePath, frame);
            }
        }
        return null;
    }

    public void resizeCache(int max_size) {
        CacheObject[] oldObjs = this.objs;
        if (max_size != this.objs.length && max_size > 0) {
            this.objs = new CacheObject[max_size];
        }
        for (int i = 0; i < this.objs.length && i < oldObjs.length; ++i) {
            DTEDCacheObject dco = (DTEDCacheObject)oldObjs[i];
            if (dco == null) {
                this.objs[i] = null;
                continue;
            }
            DTEDFrame frame = (DTEDFrame)dco.obj;
            dco.cachedTime = 0;
            if (frame == null) {
                Debug.output("DTEDFrameCache: No Frame for key!");
                continue;
            }
            if (oldObjs == this.objs) continue;
            this.objs[i] = i < oldObjs.length ? oldObjs[i] : null;
        }
        oldObjs = null;
    }

    public int getHighestResLevel() {
        return this.highestResLevel;
    }

    public void setHighestResLevel(int highestResLevel) {
        this.highestResLevel = highestResLevel;
    }

    public int getElevation(float lat, float lon) {
        for (int i = this.highestResLevel; i >= 0; --i) {
            DTEDFrame frame;
            String dtedFileName = this.findFileName(lat, lon, i);
            if (dtedFileName == null || (frame = (DTEDFrame)this.get(dtedFileName)) == null) continue;
            return frame.elevationAt(lat, lon);
        }
        return -32767;
    }

    public int getElevation(float lat, float lon, int level) {
        DTEDFrame frame;
        String dtedFileName = this.findFileName(lat, lon, level);
        if (dtedFileName != null && (frame = (DTEDFrame)this.get(dtedFileName)) != null) {
            return frame.elevationAt(lat, lon);
        }
        return -32767;
    }

    public short[][] getElevations(EqualArc proj, int dtedLevel) {
        Object ul = proj.getUpperLeft();
        Object lr = proj.getLowerRight();
        return this.getElevations((float)((Point2D)ul).getY(), (float)((Point2D)ul).getX(), (float)((Point2D)lr).getY(), (float)((Point2D)lr).getX(), dtedLevel);
    }

    public short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel) {
        return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, null);
    }

    protected short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel, DTEDFrame refFrame) {
        int y;
        int x;
        float upper = ullat;
        float lower = lrlat;
        float right = lrlon;
        float left = ullon;
        if (ullon > lrlon) {
            if (ullon > 0.0f && lrlon < 0.0f) {
                Debug.error("DTEDFrameCache: getElevations: Stradling dateline not handled!");
                return null;
            }
            right = ullon;
            left = lrlon;
        }
        if (lrlat > ullat) {
            upper = lrlat;
            lower = ullat;
        }
        float upperlat = 0.0f;
        float upperlon = 0.0f;
        float lowerlat = 0.0f;
        float lowerlon = 0.0f;
        int xSize = (int)(Math.ceil(right) - Math.floor(left));
        int ySize = (int)(Math.ceil(upper) - Math.floor(lower));
        int[] xLengths = new int[xSize];
        int[] yLengths = new int[ySize];
        short[][][][] es = new short[xSize][ySize][][];
        DTEDFrame frame = null;
        boolean needCalc = false;
        for (x = 0; x < xSize; ++x) {
            lowerlon = x == 0 ? left : (float)Math.floor(left) + (float)x;
            upperlon = x == xSize - 1 ? right : (float)Math.floor(left) + (float)(x + 1);
            for (y = 0; y < ySize; ++y) {
                lowerlat = y == 0 ? lower : (float)Math.floor(lower) + (float)y;
                upperlat = y == ySize - 1 ? upper : (float)Math.floor(lower) + (float)(y + 1);
                DTEDFrame thisFrame = this.get(lowerlat, lowerlon, dtedLevel);
                if (thisFrame != null) {
                    es[x][y] = thisFrame.getElevations(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = es[x][y].length;
                    yLengths[y] = es[x][y][0].length;
                    frame = thisFrame;
                    continue;
                }
                if (refFrame != null) {
                    Debug.output("DTEDFrameCache: Missing frames, going to use reference frame");
                    int[] indexes = refFrame.getIndexesFromLatLons(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = indexes[2] - indexes[0] + 1;
                    yLengths[y] = indexes[3] - indexes[1] + 1;
                    continue;
                }
                if (frame != null) {
                    return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
                }
                needCalc = true;
            }
        }
        if (needCalc && frame != null) {
            return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
        }
        int xLength = 0;
        int yLength = 0;
        for (x = 0; x < xLengths.length; ++x) {
            xLength += xLengths[x];
        }
        for (y = 0; y < yLengths.length; ++y) {
            yLength += yLengths[y];
        }
        short[][] matrix = new short[xLength][yLength];
        int xspacer = 0;
        for (x = 0; x < es.length; ++x) {
            int yspacer = 0;
            for (y = 0; y < es[x].length; ++y) {
                if (es[x][y] != null) {
                    for (int i = 0; i < es[x][y].length; ++i) {
                        System.arraycopy(es[x][y][i], 0, matrix[i + xspacer], yspacer, es[x][y][i].length);
                    }
                    yspacer += yLengths[y];
                    continue;
                }
                yspacer += xLengths[y];
            }
            xspacer += xLengths[x];
        }
        return matrix;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        Vector<String> directoryHandlerList = PropUtils.parseSpacedMarkers(props.getProperty(prefix + DTEDDirectoryHandlerProperty));
        for (String handlerPrefix : directoryHandlerList) {
            DTEDDirectoryHandler handler = new DTEDDirectoryHandler();
            handler.setProperties(prefix + handlerPrefix, props);
            this.addDTEDDirectoryHandler(handler);
        }
        this.resetCache(PropUtils.intFromProperties(props, prefix + DTEDFrameCacheSizeProperty, this.DEFAULT_CACHE_SIZE));
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + DTEDFrameCacheSizeProperty, Integer.toString(this.getCacheSize()));
        if (this.directories != null) {
            StringBuffer dhPrefixes = new StringBuffer();
            for (DTEDDirectoryHandler ddh : this.directories) {
                String dhPrefix = ddh.getPropertyPrefix();
                if (dhPrefix == null) continue;
                int index = dhPrefix.indexOf(prefix);
                if (index != -1) {
                    dhPrefixes.append(dhPrefix.substring(index + prefix.length())).append(" ");
                }
                ddh.getProperties(props);
            }
            props.put(prefix + DTEDDirectoryHandlerProperty, dhPrefixes.toString());
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(DTEDFrameCacheSizeProperty, "Size of the frame cache");
        return props;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("DTEDFrameCache:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameCache: " + args[0]);
        DTEDFrameCache dfc = new DTEDFrameCache(10);
        float ullat = 37.002f;
        float ullon = -121.002f;
        float lrlat = 35.998f;
        float lrlon = -119.998f;
        short[][] e = dfc.getElevations(ullat, ullon, lrlat, lrlon, 0);
        if (e != null) {
            for (int i = e[0].length - 1; i >= 0; --i) {
                int col = 0;
                System.out.print("r" + i + "-");
                for (int j = 0; j < e.length; ++j) {
                    System.out.print(e[j][i] + " ");
                    ++col;
                }
                System.out.println(" - " + col);
            }
        }
    }

    private static class DTEDCacheObject
    extends CacheObject {
        public DTEDCacheObject(String id, DTEDFrame obj) {
            super(id, obj);
        }

        protected void finalize() {
            ((DTEDFrame)this.obj).dispose();
        }
    }
}

