/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class GeneralASRPFile {
    protected DDFModule info;
    protected Hashtable fields = new Hashtable();

    protected DDFModule load(String fileName) throws IOException {
        this.info = new DDFModule(fileName);
        return this.info;
    }

    protected boolean loadField(DDFRecord record, String tagName, int fieldIndex) {
        DDFField ddf;
        if (this.fields.get(tagName) == null && (ddf = record.findField(tagName, fieldIndex)) != null) {
            this.fields.put(tagName, ddf);
            ddf.toString();
            return true;
        }
        return false;
    }

    protected void addField(DDFField ddf) {
        Object f;
        String fName = ddf.getFieldDefn().getName().trim().intern();
        if (Debug.debugging("asrp")) {
            Debug.output("GeneralASRPFile.addField(" + fName + ")");
        }
        if ((f = this.fields.get(fName)) == null) {
            this.fields.put(fName, ddf);
        } else if (f instanceof List) {
            ((List)f).add(ddf);
        } else {
            Vector<Object> subList = new Vector<Object>();
            subList.add(f);
            subList.add(ddf);
            this.fields.put(fName, subList);
        }
    }

    public List getFields(String tag) {
        Object obj = this.fields.get(tag);
        if (obj instanceof List) {
            return (List)obj;
        }
        LinkedList ll = new LinkedList();
        ll.add(obj);
        return ll;
    }

    public DDFField getField(String tag) {
        Object obj = this.fields.get(tag);
        if (obj instanceof List) {
            return (DDFField)((List)obj).get(0);
        }
        return (DDFField)obj;
    }

    public void dumpFields() {
        Iterator it = this.fields.keySet().iterator();
        while (it.hasNext()) {
            Debug.output(this.fields.get(it.next()).toString());
        }
    }

    protected DDFModule getInfo() {
        return this.info;
    }

    protected void close() {
        if (this.info != null) {
            this.info.close();
        }
    }

    public void dump() {
        if (this.info != null) {
            Debug.output(this.info.dump());
        }
    }
}

