/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.asrp.ASRPDirectory;
import com.bbn.openmap.dataAccess.asrp.TransmittalHeaderFile;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ASRPDirectoryHandler {
    protected List asrpDirs;

    public OMGraphicList getCoverageBounds(Projection proj, DrawingAttributes da) {
        OMGraphicList list = new OMGraphicList();
        List asrps = this.getASRPDirs();
        Iterator it = asrps.iterator();
        while (it.hasNext()) {
            OMRect rect = ((ASRPDirectory)it.next()).getBounds();
            da.setTo(rect);
            rect.generate(proj);
            list.add(rect);
        }
        return list;
    }

    public OMGraphicList getImagesForProjection(EqualArc proj) throws IOException {
        OMGraphicList ret = new OMGraphicList();
        if (proj == null) {
            return null;
        }
        List asrps = this.getASRPDirs();
        LinkedList<ASRPDirectory> currentBestASRPs = new LinkedList<ASRPDirectory>();
        double bestScaleDiff = Double.MAX_VALUE;
        Iterator it = asrps.iterator();
        while (it.hasNext()) {
            ASRPDirectory current;
            try {
                current = (ASRPDirectory)it.next();
            }
            catch (ClassCastException cce) {
                Debug.message("asrp", "ASRPDirectoryHandler.getImagesForProjection:  ASRP directory list contains something other than ASRPDirectory objects");
                continue;
            }
            if (!current.isOnMap(proj) || !current.validScale(proj)) continue;
            double scaleDiff = Math.abs(proj.getXPixConstant() - (double)current.arv);
            if (scaleDiff < bestScaleDiff) {
                if (Debug.debugging("asrp")) {
                    Debug.output("ASRPDirHandler: SETTING new diff (" + scaleDiff + ") adding ASRPDirectory " + current.dir);
                }
                bestScaleDiff = scaleDiff;
                currentBestASRPs.clear();
                currentBestASRPs.add(current);
                continue;
            }
            if (scaleDiff != bestScaleDiff) continue;
            if (Debug.debugging("asrp")) {
                Debug.output("ASRPDirHandler: USING current diff (" + scaleDiff + ") adding ASRPDirectory " + current.dir);
            }
            currentBestASRPs.add(current);
        }
        for (ASRPDirectory current : currentBestASRPs) {
            OMGraphicList subList;
            if (Debug.debugging("asrp")) {
                Debug.output("ASRPDirHandler: getting images from " + current.dir);
            }
            if (!(subList = current.getTiledImages(proj)).isEmpty()) {
                ret.add(subList);
                continue;
            }
            if (!Debug.debugging("asrp")) continue;
            Debug.output("ASRPDirHandler: no images retrieved (" + subList.size() + ")");
        }
        if (ret.isEmpty()) {
            ret = null;
        }
        return ret;
    }

    public void add(TransmittalHeaderFile thf) {
        if (thf != null) {
            this.getASRPDirs().addAll(thf.getASRPDirectories());
        }
    }

    public void add(ASRPDirectory asrpDir) {
        this.getASRPDirs().add(asrpDir);
    }

    public void remove(TransmittalHeaderFile thf) {
        if (thf != null) {
            this.getASRPDirs().removeAll(thf.getASRPDirectories());
        }
    }

    public void remove(ASRPDirectory asrpDir) {
        this.getASRPDirs().remove(asrpDir);
    }

    public void clear() {
        this.getASRPDirs().clear();
    }

    public List getASRPDirs() {
        if (this.asrpDirs == null) {
            this.asrpDirs = new LinkedList();
        }
        return this.asrpDirs;
    }

    public void setASRPDirs(List list) {
        this.asrpDirs = list;
    }

    public DataBounds getDataBounds() {
        DataBounds box = null;
        double minx = 180.0;
        double miny = 90.0;
        double maxx = -180.0;
        double maxy = -90.0;
        boolean set = false;
        List asrps = this.getASRPDirs();
        Iterator it = asrps.iterator();
        while (it.hasNext()) {
            OMRect rect = ((ASRPDirectory)it.next()).getBounds();
            double n = rect.getNorthLat();
            double s = rect.getSouthLat();
            double w = rect.getWestLon();
            double e = rect.getEastLon();
            if (n < miny) {
                miny = n;
            }
            if (n > maxy) {
                maxy = n;
            }
            if (s < miny) {
                miny = s;
            }
            if (s > maxy) {
                maxy = s;
            }
            if (w < minx) {
                minx = w;
            }
            if (w > maxx) {
                maxx = w;
            }
            if (e < minx) {
                minx = e;
            }
            if (e > maxx) {
                maxx = e;
            }
            set = true;
        }
        if (set) {
            box = new DataBounds(minx, miny, maxx, maxy);
            if (Debug.debugging("asrp")) {
                Debug.output("ASRPDirectoryHandler.getDataBounds(): " + box.toString());
            }
        }
        return box;
    }
}

