/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.corba;

import com.bbn.openmap.Environment;
import com.bbn.openmap.util.Debug;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class CORBASupport {
    public ORB initORB(String[] args) {
        Debug.message((String)"corba", (String)"CORBAManager.getORB(): initializing ORB");
        if (Environment.isApplet()) {
            if (Debug.debugging((String)"corba")) {
                System.out.println("CORBAManager: initializing applet");
            }
            return ORB.init((Applet)Environment.getApplet(), (Properties)Environment.getProperties());
        }
        if (Debug.debugging((String)"corba")) {
            System.out.println("CORBAManager: initializing application");
        }
        return ORB.init((String[])null, (Properties)System.getProperties());
    }

    public Object readIOR(URL iorURL) throws IOException {
        Object object = null;
        if (iorURL != null) {
            URLConnection urlConnection = iorURL.openConnection();
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(isr);
            String ior = reader.readLine();
            if (Debug.debugging((String)"corba")) {
                Debug.output((String)("CORBASupport.readIOR() using ior: " + ior));
            }
            reader.close();
            if (ior != null) {
                object = this.initORB(null).string_to_object(ior);
            }
        }
        return object;
    }

    public void writeIOR(String iorFile, Object iorObj) throws IOException {
        if (iorFile != null) {
            ORB orb = this.initORB(null);
            FileWriter outFile = new FileWriter(iorFile);
            PrintWriter writer = new PrintWriter(outFile);
            String ior = orb.object_to_string(iorObj);
            writer.println(ior);
            writer.close();
            if (Debug.debugging((String)"corba")) {
                Debug.output((String)orb.object_to_string(iorObj));
            }
        }
    }

    public void setUpNamingService(String naming, Object namingObj) {
        ORB orb = this.initORB(null);
        if (naming != null) {
            Object obj = null;
            try {
                obj = orb.resolve_initial_references("NameService");
                if (Debug.debugging((String)"corba")) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): NameService Object OK");
                }
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName e) {
                Debug.error((String)("CORBASupport.setUpNamingService(): Invalid Name exception \n" + e.getMessage()));
            }
            NamingContext rootContext = NamingContextHelper.narrow((Object)obj);
            if (rootContext == null && Debug.debugging((String)"corba")) {
                Debug.output((String)"CORBASupport.setUpNamingService(): Root context null!!");
            }
            String temp = naming;
            Vector<String> components = new Vector<String>();
            int numcomponents = 0;
            String temporaryTemp = null;
            int tindex = temp.indexOf("/");
            while (tindex != -1) {
                ++numcomponents;
                temporaryTemp = temp.substring(0, tindex);
                if (Debug.debugging((String)"corba")) {
                    Debug.output((String)("CORBASupport.setUpNamingService(): Adding Name component: " + temporaryTemp));
                }
                components.addElement(temporaryTemp);
                temp = temp.substring(tindex + 1);
                tindex = temp.indexOf("/");
            }
            if (Debug.debugging((String)"corba")) {
                Debug.output((String)("CORBASupport.setUpNamingService(): Adding final Name component: " + temp));
            }
            components.addElement(temp);
            NamingContext newContext = null;
            NamingContext oldContext = rootContext;
            for (int i = 0; i < components.size() - 1; ++i) {
                NameComponent[] newName = new NameComponent[]{new NameComponent((String)components.elementAt(i), "")};
                String debugName = (String)components.elementAt(i);
                if (Debug.debugging((String)"corba")) {
                    Debug.output((String)("CORBASupport.setUpNamingService(): Working on: " + debugName));
                }
                try {
                    if (oldContext != null) {
                        newContext = NamingContextHelper.narrow((Object)oldContext.resolve(newName));
                    }
                }
                catch (NotFound nfe) {
                    try {
                        if (Debug.debugging((String)"corba")) {
                            Debug.output((String)"CORBASupport.setUpNamingService(): Doing a bind new context");
                        }
                        newContext = oldContext.bind_new_context(newName);
                    }
                    catch (AlreadyBound abe) {
                        Debug.output((String)"CORBASupport.setUpNamingService(): Already bound for new context");
                    }
                    catch (CannotProceed cpe0) {
                        Debug.output((String)"CORBASupport.setUpNamingService(): Cannot proceed for new context");
                    }
                    catch (InvalidName ine0) {
                        Debug.output((String)"CORBASupport.setUpNamingService(): Invalid Name for new context");
                    }
                    catch (NotFound nfe0) {
                        Debug.output((String)"CORBASupport.setUpNamingService(): Not found for new context");
                    }
                }
                catch (InvalidName ine) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): Invalid name");
                }
                catch (CannotProceed cpe) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): Cannot proceed");
                }
                oldContext = newContext;
            }
            NameComponent[] finalName = new NameComponent[]{new NameComponent((String)components.elementAt(components.size() - 1), "")};
            String debugName = (String)components.elementAt(components.size() - 1);
            if (Debug.debugging((String)"corba")) {
                Debug.output((String)("CORBASupport.setUpNamingService: Finally working on: " + debugName));
            }
            if (oldContext != null) {
                try {
                    if (Debug.debugging((String)"corba")) {
                        Debug.output((String)("CORBASupport.setUpNamingService(): Doing a rebind :" + orb.object_to_string((Object)oldContext)));
                    }
                    oldContext.rebind(finalName, namingObj);
                    if (Debug.debugging((String)"corba")) {
                        Debug.output((String)("CORBASupport.setUpNamingService(): Completed rebind for " + finalName[0]));
                    }
                }
                catch (CannotProceed cpe1) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): Cannot proceed in rebind");
                }
                catch (InvalidName ine1) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): Invalid Name in rebind");
                }
                catch (NotFound nfe1) {
                    Debug.output((String)"CORBASupport.setUpNamingService(): Not found in rebind");
                }
            }
        }
    }

    public Object resolveName(String naming) {
        if (naming != null) {
            try {
                ORB orb = this.initORB(null);
                if (Debug.debugging((String)"corbadetail")) {
                    this.listServices(orb);
                }
                Object obj = null;
                try {
                    obj = orb.resolve_initial_references("NameService");
                }
                catch (Exception e) {
                    Debug.error((String)"CORBASupport.resolveName(): Error getting root naming context.");
                    e.printStackTrace();
                }
                NamingContext rootContext = NamingContextHelper.narrow((Object)obj);
                if (Debug.debugging((String)"corba") && rootContext == null) {
                    Debug.error((String)"CORBASupport.resolveName(): No root context!");
                }
                String temp = naming;
                Vector<String> components = new Vector<String>();
                int numcomponents = 0;
                String temporaryTemp = null;
                int tindex = temp.indexOf("/");
                while (tindex != -1) {
                    ++numcomponents;
                    temporaryTemp = temp.substring(0, tindex);
                    if (Debug.debugging((String)"corba")) {
                        Debug.output((String)("CORBASupport.resolveName(): Adding Name component: " + temporaryTemp));
                    }
                    components.addElement(temporaryTemp);
                    temp = temp.substring(tindex + 1);
                    tindex = temp.indexOf("/");
                }
                if (Debug.debugging((String)"corba")) {
                    Debug.output((String)("CORBASupport.resolveName(): Adding final Name component: " + temp));
                }
                components.addElement(temp);
                NameComponent[] objectName = new NameComponent[components.size()];
                for (int i = 0; i < components.size(); ++i) {
                    objectName[i] = new NameComponent((String)components.elementAt(i), "");
                }
                obj = null;
                try {
                    if (rootContext != null) {
                        obj = rootContext.resolve(objectName);
                    } else {
                        Debug.output((String)"CORBASupport.resolveName(): No Root Context for naming.");
                    }
                }
                catch (Exception e) {
                    Debug.output((String)"CORBASupport.resolveName(): Error resolving for the object.");
                    e.printStackTrace();
                }
                if (obj == null) {
                    if (Debug.debugging((String)"corba")) {
                        Debug.output((String)"CORBASupport.resolveName(): no object after resolve");
                    }
                } else if (Debug.debugging((String)"corba")) {
                    Debug.output((String)("CORBASupport.resolveName(): " + orb.object_to_string(obj)));
                }
                return obj;
            }
            catch (SystemException e) {
                Debug.error((String)("CORBASupport.resolveName(): " + (java.lang.Object)((java.lang.Object)e)));
            }
            catch (Throwable t) {
                Debug.output((String)("CORBASupport.resolveName(): " + t));
            }
        }
        return null;
    }

    protected void listServices(ORB orb) {
        String[] services = orb.list_initial_services();
        if (services != null) {
            Debug.output((String)"CORBASupport: Listing services:");
            for (int k = 0; k < services.length; ++k) {
                Debug.output((String)("  service " + k + ": " + services[k]));
            }
        } else {
            Debug.output((String)"CORBASupport: no services available");
        }
    }

    public void start(Servant servant, String[] args, String iorFile, String naming) {
        this.start(servant, args, iorFile, naming, true);
    }

    public void start(Servant servant, String[] args, String iorFile, String naming, boolean runORB) {
        ORB orb = this.initORB(args);
        POA poa = null;
        if (Debug.debugging((String)"corbadetail")) {
            this.listServices(orb);
        }
        try {
            Object raw = orb.resolve_initial_references("RootPOA");
            poa = POAHelper.narrow((Object)raw);
            poa.the_POAManager().activate();
        }
        catch (Exception error) {
            Debug.error((String)("Error getting root POA: " + error));
            error.printStackTrace();
            return;
        }
        try {
            poa.activate_object(servant);
        }
        catch (Exception e) {
            Debug.error((String)("Caught exception activating POA object: \n" + e.getMessage()));
        }
        try {
            this.writeIOR(iorFile, servant._this_object());
        }
        catch (IOException ioe) {
            Debug.error((String)("CORBASupport caught IOException writing IOR file to " + iorFile));
        }
        this.setUpNamingService(naming, servant._this_object());
        Debug.output((String)(servant.toString() + " is ready."));
        if (runORB) {
            orb.run();
        }
    }

    public void start(ObjectImpl obj, String[] args, String iorFile, String naming) {
        ORB orb = this.initORB(args);
        if (Debug.debugging((String)"corbadetail")) {
            this.listServices(orb);
        }
        try {
            this.writeIOR(iorFile, (Object)obj);
        }
        catch (IOException ioe) {
            Debug.error((String)("CORBASupport caught IOException writing IOR file to " + iorFile));
        }
        this.setUpNamingService(naming, (Object)obj);
        Debug.output((String)(obj.toString() + " is ready."));
    }
}

