/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.specialist.SPoly;
import com.bbn.openmap.layer.specialist.SText;
import com.bbn.openmap.layer.specialist.vpf.GraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class VPFSpecialistGraphicWarehouse
extends GraphicWarehouseSupport {
    String areaFeatures = null;
    int[] areaSkipFeatures = null;
    String edgeFeatures = null;
    int[] edgeSkipFeatures = null;
    String textFeatures = null;
    int[] textSkipFeatures = null;
    String epointFeatures = null;
    int[] epointSkipFeatures = null;
    String cpointFeatures = null;
    int[] cpointSkipFeatures = null;
    DrawingAttributes drawAtt = new DrawingAttributes();
    static final transient Color aaronscolor = new Color(12443267);

    public void setProperties(String prefix, Properties props) {
        String forceFeatureTypes = props.getProperty(prefix + ".draw");
        this.areaFeatures = props.getProperty(prefix + ".area");
        if (this.areaFeatures == null) {
            this.areaSkipFeatures = new int[0];
        } else {
            this.areaSkipFeatures = null;
            if (forceFeatureTypes != null) {
                this.setAreaFeatures(this.drawAreaFeatures() || forceFeatureTypes.indexOf("area") != -1);
            }
        }
        this.textFeatures = props.getProperty(prefix + ".text");
        if (this.textFeatures == null) {
            this.textSkipFeatures = new int[0];
        } else {
            this.textSkipFeatures = null;
            if (forceFeatureTypes != null) {
                this.setTextFeatures(this.drawTextFeatures() || forceFeatureTypes.indexOf("text") != -1);
            }
        }
        this.edgeFeatures = props.getProperty(prefix + ".edge");
        if (this.edgeFeatures == null) {
            this.edgeSkipFeatures = new int[0];
        } else {
            this.edgeSkipFeatures = null;
            if (forceFeatureTypes != null) {
                this.setEdgeFeatures(this.drawEdgeFeatures() || forceFeatureTypes.indexOf("edge") != -1);
            }
        }
        this.drawAtt.setProperties(prefix, props);
    }

    protected int[] getSkipArray(String featureString, DcwRecordFile table, String colAppend) {
        ArrayList<Integer> tmpvec = new ArrayList<Integer>();
        if (featureString != null) {
            StringTokenizer t = new StringTokenizer(featureString);
            while (t.hasMoreTokens()) {
                int colnum;
                String colname = t.nextToken();
                if (colAppend != null) {
                    colname = colname + colAppend;
                }
                if ((colnum = table.whatColumn(colname)) == -1) continue;
                tmpvec.add(new Integer(colnum));
            }
        }
        int[] retval = new int[tmpvec.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (Integer)tmpvec.get(i);
        }
        return retval;
    }

    protected boolean createFeature(List primvec, int[] skipArray) {
        if (skipArray.length == 0) {
            return true;
        }
        for (int i = 0; i < skipArray.length; ++i) {
            int val = VPFUtil.objectToInt(primvec.get(skipArray[i]));
            if (val == Integer.MIN_VALUE) continue;
            return true;
        }
        return false;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon) {
        if (this.areaSkipFeatures == null) {
            this.areaSkipFeatures = this.getSkipArray(this.areaFeatures, (DcwRecordFile)areatable, ".aft_id");
        }
        if (!this.createFeature(facevec, this.areaSkipFeatures)) {
            return;
        }
        ArrayList ipts = new ArrayList();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            return;
        }
        if (totalSize == 0) {
            return;
        }
        SPoly py = this.createAreaSPoly(ipts, totalSize, ll1, ll2, (float)dpplat, (float)dpplon);
        if (py == null) {
            return;
        }
        Color fc = (Color)this.drawAtt.getFillPaint();
        if (fc == null) {
            fc = Color.black;
        }
        py.color(VPFSpecialistGraphicWarehouse.ns(fc));
        py.fillColor(VPFSpecialistGraphicWarehouse.ns(fc));
        this.graphics.addSGraphic(py);
    }

    public void createEdge(CoverageTable covtable, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords) {
        if (this.edgeSkipFeatures == null) {
            this.edgeSkipFeatures = this.getSkipArray(this.edgeFeatures, (DcwRecordFile)edgetable, ".lft_id");
        }
        if (!this.createFeature(edgevec, this.edgeSkipFeatures)) {
            return;
        }
        SPoly py = this.createEdgeSPoly(coords, ll1, ll2, (float)dpplat, (float)dpplon);
        if (py == null) {
            return;
        }
        Color lc = (Color)this.drawAtt.getLinePaint();
        if (lc == null) {
            lc = Color.black;
        }
        py.color(VPFSpecialistGraphicWarehouse.ns(lc));
        py.lineWidth((short)((BasicStroke)this.drawAtt.getStroke()).getLineWidth());
        this.graphics.addSGraphic(py);
    }

    public void createText(CoverageTable covtable, TextTable texttable, List textvec, double latitude, double longitude, String text) {
        if (this.textSkipFeatures == null) {
            this.textSkipFeatures = this.getSkipArray(this.textFeatures, (DcwRecordFile)texttable, ".tft_id");
        }
        if (!this.createFeature(textvec, this.textSkipFeatures)) {
            return;
        }
        SText py = this.createTextSText(text, (float)latitude, (float)longitude);
        if (py == null) {
            return;
        }
        Color tc = (Color)this.drawAtt.getLinePaint();
        if (tc == null) {
            tc = Color.black;
        }
        py.color(VPFSpecialistGraphicWarehouse.ns(tc));
        this.graphics.addSGraphic(py);
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, double latitude, double longitude, boolean isEntityNode) {
    }
}

