/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.BooleanType;
import org.jacorb.idl.Case;
import org.jacorb.idl.CharType;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.EnumType;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.LongLongType;
import org.jacorb.idl.LongType;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.NoHelperException;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.SwitchBody;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class UnionType
extends TypeDeclaration
implements Scope {
    TypeSpec switch_type_spec;
    SwitchBody switch_body;
    private boolean written = false;
    private ScopeData scopeData;
    private boolean allCasesCovered = false;
    private boolean switch_is_enum = false;
    private boolean switch_is_bool = false;
    private boolean switch_is_longlong = false;
    private boolean explicit_default_case = false;
    private boolean isParsed = false;
    private int labels;

    public UnionType(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public Object clone() {
        UnionType ut = new UnionType(UnionType.new_num());
        ut.switch_type_spec = this.switch_type_spec;
        ut.switch_body = this.switch_body;
        ut.pack_name = this.pack_name;
        ut.name = this.name;
        ut.written = this.written;
        ut.scopeData = this.scopeData;
        ut.enclosing_symbol = this.enclosing_symbol;
        ut.token = this.token;
        return ut;
    }

    @Override
    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    @Override
    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        if (this.switch_body != null) {
            this.switch_body.setEnclosingSymbol(s);
        }
    }

    @Override
    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String className() {
        String fullName = this.typeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    @Override
    public String printReadExpression(String Streamname) {
        return this.typeName() + "Helper.read(" + Streamname + ")";
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return this.typeName() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    @Override
    public String holderName() {
        return this.typeName() + "Holder";
    }

    @Override
    public String helperName() {
        return this.typeName() + "Helper";
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    public void setSwitchType(TypeSpec s) {
        this.switch_type_spec = s;
    }

    public void setSwitchBody(SwitchBody sb) {
        this.switch_body = sb;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.switch_type_spec != null) {
            this.switch_type_spec.setPackage(s);
        }
        if (this.switch_body != null) {
            this.switch_body.setPackage(s);
        }
    }

    @Override
    public boolean basic() {
        return false;
    }

    @Override
    public void parse() {
        if (this.isParsed) {
            return;
        }
        this.isParsed = true;
        boolean justAnotherOne = false;
        this.escapeName();
        ConstrTypeSpec ctspec = new ConstrTypeSpec(UnionType.new_num());
        try {
            ScopedName.definePseudoScope(this.full_name());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), IDLTypes.TYPE_UNION);
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            Object forwardDeclaration = parser.get_pending(this.full_name());
            if (forwardDeclaration != null) {
                if (!(forwardDeclaration instanceof UnionType)) {
                    parser.error("Forward declaration types mismatch for " + this.full_name() + ": name already defined with another type", this.token);
                }
                if (this.switch_type_spec == null) {
                    justAnotherOne = true;
                }
                if (!this.full_name().equals("org.omg.CORBA.TypeCode") && this.switch_type_spec != null) {
                    TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
                }
            }
            parser.error("Union " + this.full_name() + " already defined", this.token);
        }
        if (this.switch_type_spec != null) {
            TypeSpec ts;
            if (this.switch_type_spec.type_spec instanceof ScopedName) {
                ts = ((ScopedName)this.switch_type_spec.type_spec).resolvedTypeSpec();
                while (ts instanceof ScopedName || ts instanceof AliasTypeSpec) {
                    if (ts instanceof ScopedName) {
                        ts = ((ScopedName)ts).resolvedTypeSpec();
                        continue;
                    }
                    ts = ((AliasTypeSpec)ts).originalType();
                }
                this.addImportedName(this.switch_type_spec.typeName());
            } else {
                ts = this.switch_type_spec.type_spec;
            }
            if (!(ts instanceof SwitchTypeSpec && ((SwitchTypeSpec)((Object)ts)).isSwitchable() || ts instanceof BaseType && ((BaseType)ts).isSwitchType() || ts instanceof ConstrTypeSpec && ((ConstrTypeSpec)ts).c_type_spec instanceof EnumType)) {
                parser.error("Illegal Switch Type: " + ts.typeName(), this.token);
            }
            this.switch_type_spec.parse();
            this.switch_body.setTypeSpec(this.switch_type_spec);
            this.switch_body.setUnion(this);
            ScopedName.addRecursionScope(this.typeName());
            this.switch_body.parse();
            ScopedName.removeRecursionScope(this.typeName());
            NameTable.parsed_interfaces.put(this.full_name(), "");
            parser.remove_pending(this.full_name());
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name(), this);
        }
    }

    @Override
    public String getTypeCodeExpression() {
        return this.typeName() + "Helper.type()";
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        return this.getTypeCodeExpression();
    }

    private void printUnionClass(String className, PrintWriter pw) {
        int i;
        if (!this.pack_name.equals("")) {
            pw.println("package " + this.pack_name + ";");
        }
        this.printImport(pw);
        this.printClassComment("union", className, pw);
        pw.println("public" + parser.getFinalString() + " class " + className);
        pw.println("\timplements org.omg.CORBA.portable.IDLEntity");
        pw.println("{");
        TypeSpec ts = this.switch_type_spec.typeSpec();
        while (ts instanceof ScopedName || ts instanceof AliasTypeSpec) {
            if (ts instanceof ScopedName) {
                ts = ((ScopedName)ts).resolvedTypeSpec();
            }
            if (!(ts instanceof AliasTypeSpec)) continue;
            ts = ((AliasTypeSpec)ts).originalType();
        }
        pw.println("\tprivate " + ts.typeName() + " discriminator;");
        String defaultStr = "";
        int def = 0;
        Vector<String> allCaseLabels = new Vector<String>();
        Vector<String> unusedCaseLabels = new Vector<String>();
        Enumeration e = this.switch_body.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case c = (Case)e.nextElement();
            for (i = 0; i < c.case_label_list.v.size(); ++i) {
                ++this.labels;
                Object ce = c.case_label_list.v.elementAt(i);
                if (ce != null) {
                    if (ce instanceof ConstExpr) {
                        allCaseLabels.addElement(((ConstExpr)ce).toString());
                        continue;
                    }
                    allCaseLabels.addElement(ScopedName.unPseudoName(((ScopedName)ce).resolvedName()));
                    continue;
                }
                def = 1;
                this.explicit_default_case = true;
            }
        }
        if (ts instanceof ConstrTypeSpec && ((ConstrTypeSpec)ts).declaration() instanceof EnumType) {
            this.switch_is_enum = true;
            EnumType et = (EnumType)((ConstrTypeSpec)ts).declaration();
            if (allCaseLabels.size() + def > et.size()) {
                lexer.emit_warn("Too many case labels in definition of union " + this.full_name() + ", default cannot apply", this.token);
            }
            if (allCaseLabels.size() + def == et.size()) {
                this.allCasesCovered = true;
            }
            for (i = 0; i < et.size(); ++i) {
                String qualifiedCaseLabel = ts.typeName() + "." + (String)et.enumlist.v.elementAt(i);
                if (allCaseLabels.contains(qualifiedCaseLabel)) continue;
                if (defaultStr.length() == 0) {
                    defaultStr = qualifiedCaseLabel;
                }
                unusedCaseLabels.addElement(qualifiedCaseLabel);
            }
        } else {
            if (ts instanceof BaseType) {
                ts = ((BaseType)ts).typeSpec();
            }
            if (ts instanceof BooleanType) {
                this.switch_is_bool = true;
                if (allCaseLabels.size() + def > 2) {
                    parser.error("Case label error: too many default labels.", this.token);
                    return;
                }
                if (allCaseLabels.size() == 1) {
                    defaultStr = ((String)allCaseLabels.elementAt(0)).equals("true") ? "false" : "true";
                }
            } else if (ts instanceof CharType) {
                boolean matched = false;
                for (short s = 0; s < 256; s = (short)((short)(s + 1))) {
                    matched = false;
                    Enumeration enumeration = allCaseLabels.elements();
                    while (enumeration.hasMoreElements()) {
                        short val;
                        String charStr = (String)enumeration.nextElement();
                        if ((charStr = charStr.substring(1, charStr.length() - 1)).charAt(0) == '\\') {
                            charStr = charStr.substring(1);
                            val = Short.parseShort(charStr);
                        } else {
                            val = (short)charStr.charAt(0);
                        }
                        if (s != val) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    defaultStr = "(char)" + s;
                    break;
                }
            } else if (ts instanceof IntType) {
                int maxint = 65536;
                if (ts instanceof LongType) {
                    maxint = Integer.MAX_VALUE;
                }
                for (i = 0; i < maxint; ++i) {
                    if (allCaseLabels.contains(String.valueOf(i))) continue;
                    defaultStr = Integer.toString(i);
                    break;
                }
                if (ts instanceof LongLongType) {
                    this.switch_is_longlong = true;
                }
            } else {
                parser.logger.log(Level.SEVERE, "Something went wrong in UnionType, could not identify switch type " + this.switch_type_spec.type_spec);
            }
        }
        e = this.switch_body.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case c = (Case)e.nextElement();
            pw.println("\tprivate " + c.element_spec.typeSpec.typeName() + " " + c.element_spec.declarator.name() + ";");
        }
        pw.println(Environment.NL + "\tpublic " + className + " ()");
        pw.println("\t{");
        pw.println("\t}" + Environment.NL);
        pw.println("\tpublic " + ts.typeName() + " discriminator ()");
        pw.println("\t{");
        pw.println("\t\treturn discriminator;");
        pw.println("\t}" + Environment.NL);
        e = this.switch_body.caseListVector.elements();
        while (e.hasMoreElements()) {
            String lab;
            int i2;
            Case c = (Case)e.nextElement();
            boolean thisCaseIsDefault = false;
            int caseLabelNum = c.case_label_list.v.size();
            String[] label = new String[caseLabelNum];
            for (int i3 = 0; i3 < caseLabelNum; ++i3) {
                Object o = c.case_label_list.v.elementAt(i3);
                if (o == null) {
                    label[i3] = null;
                    thisCaseIsDefault = true;
                    continue;
                }
                if (o instanceof ConstExpr) {
                    label[i3] = ((ConstExpr)o).toString();
                    continue;
                }
                if (!(o instanceof ScopedName)) continue;
                label[i3] = ((ScopedName)o).typeName();
            }
            pw.println("\tpublic " + c.element_spec.typeSpec.typeName() + " " + c.element_spec.declarator.name() + " ()");
            pw.println("\t{");
            pw.print("\t\tif (discriminator != ");
            boolean defaultFound = false;
            for (i2 = 0; i2 < caseLabelNum; ++i2) {
                if (label[i2] == null) {
                    defaultFound = true;
                    pw.print(defaultStr);
                } else {
                    pw.print(label[i2]);
                }
                if (i2 >= caseLabelNum - 1) continue;
                pw.print(" && discriminator != ");
            }
            if (defaultFound) {
                for (i2 = 0; i2 < unusedCaseLabels.size(); ++i2) {
                    lab = (String)unusedCaseLabels.elementAt(i2);
                    if (lab.equals(defaultStr)) continue;
                    pw.print(" && discriminator != " + lab);
                }
            }
            pw.println(")" + Environment.NL + "\t\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
            pw.println("\t\treturn " + c.element_spec.declarator.name() + ";");
            pw.println("\t}" + Environment.NL);
            pw.println("\tpublic void " + c.element_spec.declarator.name() + " (" + c.element_spec.typeSpec.typeName() + " _x)");
            pw.println("\t{");
            pw.print("\t\tdiscriminator = ");
            if (label[0] == null) {
                pw.println(defaultStr + ";");
            } else {
                pw.println(label[0] + ";");
            }
            pw.println("\t\t" + c.element_spec.declarator.name() + " = _x;");
            pw.println("\t}" + Environment.NL);
            if (caseLabelNum <= 1 && !thisCaseIsDefault) continue;
            pw.println("\tpublic void " + c.element_spec.declarator.name() + " (" + ts.typeName() + " _discriminator, " + c.element_spec.typeSpec.typeName() + " _x)");
            pw.println("\t{");
            pw.print("\t\tif (_discriminator != ");
            defaultFound = false;
            for (i2 = 0; i2 < caseLabelNum; ++i2) {
                if (label[i2] == null) {
                    defaultFound = true;
                    pw.print(defaultStr);
                } else {
                    pw.print(label[i2]);
                }
                if (i2 >= caseLabelNum - 1) continue;
                pw.print(" && _discriminator != ");
            }
            if (defaultFound) {
                for (i2 = 0; i2 < unusedCaseLabels.size(); ++i2) {
                    lab = (String)unusedCaseLabels.elementAt(i2);
                    if (lab.equals(defaultStr)) continue;
                    pw.print(" && _discriminator != " + lab);
                }
            }
            pw.println(")" + Environment.NL + "\t\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
            pw.println("\t\tdiscriminator = _discriminator;");
            pw.println("\t\t" + c.element_spec.declarator.name() + " = _x;");
            pw.println("\t}" + Environment.NL);
        }
        if (parser.generateEnhanced) {
            this.printToString(className, pw, defaultStr);
        }
        if (def == 0 && defaultStr.length() > 0) {
            pw.println("\tpublic void __default ()");
            pw.println("\t{");
            pw.println("\t\tdiscriminator = " + defaultStr + ";");
            pw.println("\t}");
            pw.println("\tpublic void __default (" + ts.typeName() + " _discriminator)");
            pw.println("\t{");
            pw.print("\t\tif( ");
            for (int i4 = 0; i4 < allCaseLabels.size(); ++i4) {
                String lab = (String)allCaseLabels.elementAt(i4);
                if (i4 == 0) {
                    pw.print(" _discriminator == " + lab);
                    continue;
                }
                pw.print(" || _discriminator == " + lab);
            }
            pw.println(" )" + Environment.NL + "\t\t\tthrow new org.omg.CORBA.BAD_PARAM( \"Illegal value is used in __default method\"," + " 34, org.omg.CORBA.CompletionStatus.COMPLETED_NO );" + Environment.NL);
            pw.println("\t\tdiscriminator = _discriminator;");
            pw.println("\t}");
        }
        pw.println("}");
    }

    private void printToString(String s, PrintWriter pw, String defaultStr) {
        String indent1 = "\t\t\t";
        String indent2 = "\t\t\t\t";
        if (this.switch_is_longlong) {
            indent1 = "\t\t";
            indent2 = "\t\t\t";
        }
        String case_str = "case ";
        String colon_str = ":";
        String default_str = "default:";
        pw.println("\tpublic String toString()");
        pw.println("\t{");
        pw.println("\t\tfinal java.lang.StringBuffer _ret = new java.lang.StringBuffer();");
        pw.print("\t\t_ret.append(\"union ");
        pw.print(s);
        pw.println(" {\");");
        pw.println("\t\t_ret.append(\"\\n\");");
        if (this.switch_is_enum) {
            pw.println("\t\tswitch (discriminator.value ())");
            pw.println("\t\t{");
        } else if (this.switch_is_bool) {
            case_str = "if (discriminator  ==";
            colon_str = ")";
        } else if (this.switch_is_longlong) {
            pw.println("\t\tlong disc = discriminator ;");
        } else {
            pw.println("\t\tswitch (discriminator )");
            pw.println("\t\t{");
        }
        UnionIterator ui = new UnionIterator(false){

            @Override
            protected String writeExpression(PrintWriter caseWriter, Case cse, int caseLabelNum, String indent2, Object o) {
                caseWriter.print("\t\t\t\t_ret.append(");
                caseWriter.print(cse.element_spec.declarator.name());
                caseWriter.println(");");
                if (o != null && !UnionType.this.switch_is_bool && !UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "break;");
                }
                if (UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "return;");
                }
                return null;
            }
        };
        ui.iterate(pw, indent1, indent2, "", case_str, colon_str, default_str);
        pw.println("\t\t_ret.append(\"}\");");
        pw.println("\t\treturn _ret.toString();");
        pw.println("\t}");
        pw.println();
    }

    public void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printClassComment("union", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + className + " value;" + Environment.NL);
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + className + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (out, value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment("union", className, ps);
        ps.println("public abstract class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate volatile static org.omg.CORBA.TypeCode _type;");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        ps.println("\t\t\tsynchronized(" + this.name + "Helper.class)");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif (_type == null)");
        ps.println("\t\t\t\t{");
        ps.println("\t\t\torg.omg.CORBA.UnionMember[] members = new org.omg.CORBA.UnionMember[" + this.labels + "];");
        ps.println("\t\t\torg.omg.CORBA.Any label_any;");
        TypeSpec label_t = this.switch_type_spec.typeSpec();
        if (label_t instanceof ScopedName) {
            label_t = ((ScopedName)label_t).resolvedTypeSpec();
        }
        label_t = label_t.typeSpec();
        Enumeration e = this.switch_body.caseListVector.elements();
        int mi = 0;
        while (e.hasMoreElements()) {
            Case cse = (Case)e.nextElement();
            TypeSpec t = cse.element_spec.typeSpec;
            if (t instanceof ScopedName) {
                t = ((ScopedName)t).resolvedTypeSpec();
            }
            t = t.typeSpec();
            Declarator d = cse.element_spec.declarator;
            int caseLabelNum = cse.case_label_list.v.size();
            for (int i = 0; i < caseLabelNum; ++i) {
                Object o = cse.case_label_list.v.elementAt(i);
                ps.println("\t\t\tlabel_any = org.omg.CORBA.ORB.init().create_any ();");
                TypeSpec tocheck = label_t;
                if (label_t instanceof AliasTypeSpec) {
                    tocheck = ((AliasTypeSpec)label_t).originalType();
                }
                if (o == null) {
                    ps.println("\t\t\tlabel_any.insert_octet ((byte)0);");
                } else if (tocheck instanceof BaseType) {
                    if (tocheck instanceof CharType || tocheck instanceof BooleanType || tocheck instanceof LongType || tocheck instanceof LongLongType) {
                        ps.print("\t\t\tlabel_any." + tocheck.printInsertExpression() + " ((");
                    } else if (tocheck instanceof ShortType) {
                        ps.print("\t\t\tlabel_any." + tocheck.printInsertExpression() + " ((short)(");
                    } else {
                        throw new RuntimeException("Compiler error: unrecognized BaseType: " + tocheck.typeName() + ":" + tocheck + ": " + tocheck.typeSpec() + ": " + tocheck.getClass().getName());
                    }
                    ps.println((ConstExpr)o + "));");
                } else if (this.switch_is_enum) {
                    String _t = ((ScopedName)o).typeName();
                    ps.println("\t\t\t" + _t.substring(0, _t.lastIndexOf(46)) + "Helper.insert(label_any, " + _t + ");");
                } else {
                    throw new RuntimeException("Compiler error: unrecognized label type: " + tocheck.typeName());
                }
                ps.print("\t\t\tmembers[" + mi++ + "] = new org.omg.CORBA.UnionMember (\"" + d.deEscapeName() + "\", label_any, ");
                if (t instanceof ConstrTypeSpec) {
                    try {
                        ps.print(t.typeSpec().helperName() + ".type(),");
                    }
                    catch (NoHelperException ex) {
                        ps.print(t.typeSpec().getTypeCodeExpression() + ",");
                    }
                } else {
                    ps.print(t.typeSpec().getTypeCodeExpression() + ",");
                }
                ps.println("null);");
            }
        }
        ps.print("\t\t\t _type = org.omg.CORBA.ORB.init().create_union_tc(id(),\"" + this.className() + "\",");
        ps.println(this.switch_type_spec.typeSpec().getTypeCodeExpression() + ", members);");
        ps.println("\t\t\t\t}");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t\t\treturn _type;");
        ps.println("\t}" + Environment.NL);
        TypeSpec.printInsertExtractMethods(ps, this.typeName());
        this.printIdMethod(ps);
        ps.println("\tpublic static " + className + " read (org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printCheckout(ps, className, "result");
            parser.getObjectCachePlugin().printPreMemberRead(ps, this);
        } else {
            ps.println("\t\t" + className + " result = new " + className + "();");
        }
        TypeSpec switch_ts_resolved = this.switch_type_spec;
        if (this.switch_type_spec.type_spec instanceof ScopedName) {
            switch_ts_resolved = ((ScopedName)this.switch_type_spec.type_spec).resolvedTypeSpec();
        }
        String indent1 = "\t\t\t";
        String indent2 = "\t\t\t\t";
        String tryIndent = "";
        if (this.switch_is_longlong) {
            indent1 = "\t\t";
            indent2 = "\t\t\t";
        }
        String case_str = "case ";
        String colon_str = ":";
        String default_str = "default:";
        if (this.switch_is_enum) {
            ps.println("\t\t" + switch_ts_resolved.toString() + " disc;");
            if (this.explicit_default_case || !this.allCasesCovered) {
                tryIndent = "\t";
                indent1 = "\t\t\t\t";
                indent2 = "\t\t\t\t\t";
                ps.println("\t\ttry");
                ps.println("\t\t{");
            }
            ps.println(tryIndent + "\t\tdisc = " + switch_ts_resolved.toString() + ".from_int(in.read_long());");
            ps.println(tryIndent + "\t\tswitch (disc.value ())");
            ps.println(tryIndent + "\t\t{");
        } else {
            ps.println("\t\t" + switch_ts_resolved.toString() + " " + switch_ts_resolved.printReadStatement("disc", "in"));
            if (this.switch_is_bool) {
                case_str = "if (disc == ";
                colon_str = ")";
                default_str = "else";
            } else if (this.switch_is_longlong) {
                case_str = "if (disc == ";
                colon_str = ")";
                default_str = "else";
            } else {
                ps.println("\t\tswitch (disc)");
                ps.println("\t\t{");
            }
        }
        UnionIterator ui = new UnionIterator(true){

            @Override
            protected String writeExpression(PrintWriter caseWriter, Case cse, int caseLabelNum, String indent2, Object o) {
                ByteArrayOutputStream bosDef = new ByteArrayOutputStream();
                PrintWriter bad_paramDefaultWriter = new PrintWriter(bosDef);
                TypeSpec t = cse.element_spec.typeSpec;
                Declarator d = cse.element_spec.declarator;
                String varname = "_var";
                if (t instanceof ScopedName) {
                    t = ((ScopedName)t).resolvedTypeSpec();
                }
                t = t.typeSpec();
                bad_paramDefaultWriter.println(indent2 + t.typeName() + " " + varname + ";");
                bad_paramDefaultWriter.println(indent2 + t.printReadStatement(varname, "in"));
                bad_paramDefaultWriter.print(indent2 + "result." + d.name() + " (");
                bad_paramDefaultWriter.close();
                caseWriter.print(bosDef.toString());
                if (caseLabelNum > 1) {
                    caseWriter.print("disc,");
                }
                caseWriter.println(varname + ");");
                if (o != null && !UnionType.this.switch_is_bool && !UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "break;");
                }
                if (UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "return result;");
                }
                return bosDef.toString();
            }
        };
        ui.iterate(ps, indent1, indent2, "", case_str, colon_str, default_str);
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printPostMemberRead(ps, this, "result");
        }
        if (!this.switch_is_longlong) {
            ps.println("\t\treturn result;");
        }
        ps.println("\t}");
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printCheckinHelper(ps, this);
        }
        ps.println("\tpublic static void write (org.omg.CORBA.portable.OutputStream out, " + className + " s)");
        ps.println("\t{");
        if (this.switch_is_enum) {
            ps.println("\t\tout.write_long (s.discriminator().value ());");
            ps.println("\t\tswitch (s.discriminator().value ())");
            ps.println("\t\t{");
        } else {
            ps.println("\t\t" + this.switch_type_spec.typeSpec().printWriteStatement("s.discriminator ()", "out"));
            if (this.switch_is_bool) {
                case_str = "if (s.discriminator () == ";
            } else if (this.switch_is_longlong) {
                ps.println("\t\tlong disc = s.discriminator ();");
            } else {
                ps.println("\t\tswitch (s.discriminator ())");
                ps.println("\t\t{");
            }
        }
        ui = new UnionIterator(false){

            @Override
            protected String writeExpression(PrintWriter caseWriter, Case cse, int caseLabelNum, String indent2, Object o) {
                TypeSpec t = cse.element_spec.typeSpec;
                Declarator d = cse.element_spec.declarator;
                if (t instanceof ScopedName) {
                    t = ((ScopedName)t).resolvedTypeSpec();
                }
                t = t.typeSpec();
                caseWriter.println(indent2 + t.printWriteStatement("s." + d.name() + " ()", "out"));
                if (o != null && !UnionType.this.switch_is_bool && !UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "break;");
                }
                if (UnionType.this.switch_is_longlong) {
                    caseWriter.println(indent2 + "return;");
                }
                return null;
            }
        };
        ui.iterate(ps, indent1, indent2, "", case_str, colon_str, default_str);
        ps.println("\t}");
        ps.println("}");
    }

    @Override
    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written && this.switch_type_spec != null) {
            try {
                PrintWriter printWriter;
                String fname;
                File f;
                if (this.switch_type_spec.type_spec instanceof ConstrTypeSpec) {
                    this.switch_type_spec.print(ps);
                }
                this.switch_body.print(ps);
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + ".java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printUnionClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, printWriter);
                    printWriter.close();
                }
                this.written = true;
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + this.pack_name + "." + this.className() + "Helper.insert(" + anyname + ", " + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.className() + "Helper.extract(" + anyname + ");");
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitUnion(this);
    }

    @Override
    public void set_name(String n) {
        boolean setpkg;
        super.set_name(n);
        boolean bl = setpkg = this.switch_type_spec != null && !(this.switch_type_spec.typeSpec() instanceof ScopedName);
        if (setpkg) {
            this.switch_type_spec.setPackage(n);
        }
        if (this.switch_body != null && setpkg) {
            this.switch_body.setPackage(n);
        }
    }

    private abstract class UnionIterator {
        boolean readExpression = false;

        UnionIterator(boolean writeExpression) {
            this.readExpression = writeExpression;
        }

        public void iterate(PrintWriter pw, String indent1, String indent2, String tryIndent, String case_str, String colon_str, String default_str) {
            boolean was_default = false;
            int caseCount = 0;
            String defaultCases = null;
            String varname = "_var";
            String bosDef = "";
            if (UnionType.this.switch_is_longlong) {
                indent1 = "\t\t";
                indent2 = "\t\t\t";
            }
            Enumeration e = UnionType.this.switch_body.caseListVector.elements();
            while (e.hasMoreElements()) {
                was_default = false;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter caseWriter = new PrintWriter(bos);
                Case cse = (Case)e.nextElement();
                int caseLabelNum = cse.case_label_list.v.size();
                for (int i = 0; i < caseLabelNum; ++i) {
                    Object o = cse.case_label_list.v.elementAt(i);
                    ++caseCount;
                    if (o == null) {
                        caseWriter.println(indent1 + default_str);
                        was_default = true;
                    } else if (o instanceof ConstExpr) {
                        caseWriter.println(indent1 + case_str + (ConstExpr)o + colon_str);
                    } else if (o instanceof ScopedName) {
                        String _t = ((ScopedName)o).typeName();
                        if (UnionType.this.switch_is_enum) {
                            caseWriter.println(indent1 + case_str + _t.substring(0, _t.lastIndexOf(46) + 1) + "_" + _t.substring(_t.lastIndexOf(46) + 1) + colon_str);
                        } else {
                            caseWriter.println(indent1 + case_str + _t + colon_str);
                        }
                    }
                    if (i != caseLabelNum - 1) continue;
                    caseWriter.println(indent1 + "{");
                    bosDef = this.writeExpression(caseWriter, cse, caseLabelNum, indent2, o);
                    caseWriter.println(indent1 + "}");
                }
                if (UnionType.this.switch_is_bool && !was_default) {
                    case_str = "else " + case_str;
                }
                caseWriter.close();
                if (bos.size() <= 0) continue;
                if (was_default) {
                    defaultCases = bos.toString();
                    continue;
                }
                pw.print(bos.toString());
            }
            if (this.readExpression) {
                if (!(!UnionType.this.switch_is_enum || UnionType.this.explicit_default_case || UnionType.this.switch_is_bool || UnionType.this.switch_is_longlong || UnionType.this.allCasesCovered)) {
                    pw.println(tryIndent + "\t\t\tdefault: result.__default (disc);");
                }
                if (!UnionType.this.explicit_default_case && UnionType.this.switch_is_longlong) {
                    pw.println("\t\tresult.__default (disc);");
                    pw.println("\t\treturn result;");
                }
                if (UnionType.this.switch_is_bool && caseCount > 2) {
                    System.err.println("Case count is larger than two for a boolean expression");
                    throw new RuntimeException("Case count is larger than two for a boolean expression");
                }
                if (!UnionType.this.explicit_default_case && UnionType.this.switch_is_bool && caseCount != 2) {
                    pw.println("\t\t\telse");
                    pw.println("\t\t\t{");
                    pw.println("\t\t\t\tresult.__default (disc);");
                    pw.println("\t\t\t}");
                }
            }
            if (defaultCases != null) {
                pw.print(defaultCases);
            }
            if (!UnionType.this.switch_is_bool && !UnionType.this.switch_is_longlong) {
                pw.println("\t\t}");
            }
            if (this.readExpression && UnionType.this.switch_is_enum && (UnionType.this.explicit_default_case || !UnionType.this.allCasesCovered)) {
                pw.println("\t\t}");
                pw.println("\t\tcatch (org.omg.CORBA.BAD_PARAM b)");
                pw.println("\t\t{");
                pw.println("\t\t\t// The default value was out-of-bounds for the Enum. Just use the default.");
                if (was_default) {
                    pw.print(bosDef);
                    pw.println(varname + ");");
                } else {
                    pw.println("\t\t\tresult.__default ();");
                }
                pw.println("\t\t}");
            }
        }

        protected abstract String writeExpression(PrintWriter var1, Case var2, int var3, String var4, Object var5);
    }
}

