/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.jacorb.orb.ORB;
import org.omg.CORBA.portable.ObjectImpl;

public class PortableRemoteObjectDelegateImpl
implements PortableRemoteObjectDelegate {
    private static ORB _orb = null;

    public static synchronized org.omg.CORBA.ORB getORB() {
        if (_orb == null) {
            _orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], null);
        }
        return _orb;
    }

    public static synchronized void setORB(org.omg.CORBA.ORB orb) {
        if (_orb != null) {
            throw new IllegalStateException("RMI orb has already been initialized");
        }
        _orb = (ORB)orb;
    }

    public void exportObject(Remote obj) throws RemoteException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof Stub) {
            throw new ExportException("Attempted to export a stub class");
        }
        Tie tie = Util.getTie((Remote)obj);
        if (tie != null) {
            throw new ExportException("Object already exported");
        }
        tie = this.toTie(obj);
        tie.orb(PortableRemoteObjectDelegateImpl.getORB());
        Util.registerTarget((Tie)tie, (Remote)obj);
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof Stub) {
            return obj;
        }
        Tie tie = null;
        if (obj instanceof Tie) {
            tie = (Tie)obj;
            obj = tie.getTarget();
        } else {
            tie = Util.getTie((Remote)obj);
        }
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        ObjectImpl thisObject = (ObjectImpl)tie.thisObject();
        String[] ids = thisObject._ids();
        for (int i = 0; i < ids.length; ++i) {
            String repoID = ids[i];
            String stubClazzName = this.newRMIStubName(repoID);
            try {
                Stub stub = this.newStub(stubClazzName, obj.getClass());
                stub._set_delegate(thisObject._get_delegate());
                return (Remote)stub;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        throw new NoSuchObjectException("Object not exported");
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)obj);
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Util.unexportObject((Remote)obj);
    }

    public Object narrow(Object obj, Class newClass) throws ClassCastException {
        if (newClass == null) {
            throw new ClassCastException("Can't narrow to null class");
        }
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        try {
            if (newClass.isAssignableFrom(fromClass)) {
                return obj;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new ClassCastException("Can't narrow from " + fromClass + " to " + newClass);
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        throw new UnsupportedOperationException("Not implemented for PortableRemoteObjectDelegateImpl");
    }

    private Tie toTie(Remote obj) throws ExportException {
        for (Class<?> clz = obj.getClass(); clz != null; clz = clz.getSuperclass()) {
            try {
                String tieClzName = this.newRMIClassName(clz.getName(), "Tie");
                return this.newTie(tieClzName, clz);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                throw new ExportException("InstantiationException: ", e);
            }
            catch (IllegalAccessException e) {
                throw new ExportException("IllegalAccessException: ", e);
            }
        }
        throw new ExportException("Tie class not found ");
    }

    private Stub newStub(String clazzName, Class source) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            return (Stub)this.newInstance(clazzName, source);
        }
        catch (ClassNotFoundException e) {
            return (Stub)this.newInstance("org.omg.stub." + clazzName, source);
        }
    }

    private Tie newTie(String clazzName, Class source) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            return (Tie)this.newInstance(clazzName, source);
        }
        catch (ClassNotFoundException e) {
            return (Tie)this.newInstance("org.omg.stub." + clazzName, source);
        }
    }

    private Object newInstance(String clazzName, Class source) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.loadClass(clazzName, source).newInstance();
    }

    private Class loadClass(String clazzName, Class source) throws ClassNotFoundException {
        return Util.loadClass((String)clazzName, (String)Util.getCodebase((Class)source), (ClassLoader)source.getClassLoader());
    }

    private String newRMIStubName(String repoID) {
        String clazzName = repoID.substring(4, repoID.lastIndexOf(58));
        return this.newRMIClassName(clazzName, "Stub");
    }

    private String newRMIClassName(String name, String suffix) {
        StringBuffer buffer = new StringBuffer(name.length() + 2 + suffix.length());
        int idx = name.lastIndexOf(46) + 1;
        buffer.append(name.substring(0, idx));
        buffer.append('_');
        buffer.append(name.substring(idx, name.length()));
        buffer.append('_');
        buffer.append(suffix);
        return buffer.toString();
    }
}

