/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends ProfileBase
implements Cloneable {
    private IIOPAddress primaryAddress = null;
    private SSL ssl = null;
    private boolean isSSLSet;
    private static final int MINIMUM_OPTIONS = 126;
    private boolean checkAlternateAddresses;

    private IIOPProfile(boolean checkAlternateAddresses) {
        this.checkAlternateAddresses = checkAlternateAddresses;
    }

    public IIOPProfile() {
        this(true);
    }

    public IIOPProfile(byte[] data) {
        this(true);
        this.initFromProfileData(data);
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey, int minor) {
        this(false);
        this.version = new Version(1, (byte)minor);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(String corbaloc) {
        this(false);
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = corbaloc;
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.logger = this.configuration.getLogger("org.jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(this.configuration);
        }
        if (this.corbalocStr != null) {
            this.decode_corbaloc(this.corbalocStr);
        }
        this.addAlternateAddresses(this.configuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode_corbaloc(String address) throws ConfigurationException {
        String addr = address;
        String host = "127.0.0.1";
        int port = 2809;
        int major = 1;
        int minor = 0;
        String errorstr = "Illegal IIOP protocol format in object address format: " + addr;
        int sep = addr.indexOf(58);
        String protocol_identifier = "";
        if (sep != 0) {
            protocol_identifier = addr.substring(0, sep);
        }
        if (sep + 1 == addr.length()) {
            throw new IllegalArgumentException(errorstr);
        }
        if ((sep = (addr = addr.substring(sep + 1)).indexOf(64)) > -1) {
            String ver_str = addr.substring(0, sep);
            addr = addr.substring(sep + 1);
            sep = ver_str.indexOf(46);
            if (sep != -1) {
                try {
                    major = Integer.parseInt(ver_str.substring(0, sep));
                    minor = Integer.parseInt(ver_str.substring(sep + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.version = new Version((byte)major, (byte)minor);
        int ipv6SeperatorStart = -1;
        int ipv6SeperatorEnd = -1;
        ipv6SeperatorStart = addr.indexOf(91);
        if (ipv6SeperatorStart != -1 && (ipv6SeperatorEnd = addr.indexOf(93)) == -1) {
            throw new IllegalArgumentException(errorstr);
        }
        sep = addr.indexOf(58);
        if (sep != -1) {
            if (ipv6SeperatorStart != -1) {
                host = addr.substring(ipv6SeperatorStart + 1, ipv6SeperatorEnd);
                if (addr.charAt(ipv6SeperatorEnd + 1) != ':') throw new IllegalArgumentException(errorstr);
                port = (short)Integer.parseInt(addr.substring(ipv6SeperatorEnd + 2));
            } else {
                try {
                    port = (short)Integer.parseInt(addr.substring(sep + 1));
                    host = addr.substring(0, sep);
                }
                catch (NumberFormatException ill) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.primaryAddress = new IIOPAddress(host, port);
        this.primaryAddress.configure(this.configuration);
        this.decode_extensions(protocol_identifier.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode_extensions(String ident) throws ConfigurationException {
        this.components = new TaggedComponentList();
        if (ident.equals("ssliop")) {
            this.ssl = new SSL();
            this.ssl.port = (short)this.primaryAddress.getPort();
            this.ssl.target_supports = this.get_ssl_options("jacorb.security.ssl.corbaloc_ssliop.supported_options");
            this.ssl.target_requires = this.get_ssl_options("jacorb.security.ssl.corbaloc_ssliop.required_options");
            this.isSSLSet = true;
            CDROutputStream out = new CDROutputStream();
            try {
                out.beginEncapsulatedArray();
                SSLHelper.write((OutputStream)out, (SSL)this.ssl);
                this.components.addComponent(new TaggedComponent(20, out.getBufferCopy()));
            }
            finally {
                out.close();
            }
        }
    }

    private short get_ssl_options(String propname) throws ConfigurationException {
        short value = (short)this.configuration.getAttributeAsInteger(propname, 32, 16);
        return value;
    }

    public void setAlternateAddresses(List<IIOPAddress> alternates) {
        if (this.components == null) {
            this.components = new TaggedComponentList();
        }
        Iterator<IIOPAddress> i = alternates.iterator();
        while (i.hasNext()) {
            this.checkAlternateAddresses = true;
            IIOPAddress addr = i.next();
            this.components.addComponent(3, addr.toCDR());
        }
    }

    private void addAlternateAddresses(Configuration config) throws ConfigurationException {
        String value = config.getAttribute("jacorb.iiop.alternate_addresses", null);
        if (value == null) {
            return;
        }
        if (value.trim().equals("auto")) {
            this.addNetworkAddresses();
        } else {
            List<String> addresses = Arrays.asList(value.split(","));
            if (!addresses.isEmpty() && this.components == null) {
                this.components = new TaggedComponentList();
            }
            for (String addr : addresses) {
                IIOPAddress iaddr = new IIOPAddress();
                iaddr.configure(config);
                if (!iaddr.fromString(addr)) {
                    this.logger.warn("could not decode " + addr + " from jacorb.iiop.alternate_addresses");
                    continue;
                }
                this.checkAlternateAddresses = true;
                this.components.addComponent(3, iaddr.toCDR());
            }
        }
    }

    public void addAllWildcardAddresses(Configuration config) throws ConfigurationException {
        if (this.primaryAddress == null) {
            return;
        }
        if (this.primaryAddress.isWildcard()) {
            this.addNetworkAddresses();
        }
    }

    private void addNetworkAddresses() throws ConfigurationException {
        if (this.primaryAddress == null) {
            return;
        }
        if (this.components == null) {
            this.components = new TaggedComponentList();
        }
        String primaryIP = this.primaryAddress.getIP();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("primaryIP is <" + primaryIP + ">");
        }
        for (InetAddress addr : IIOPAddress.getNetworkInetAddresses()) {
            if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) continue;
            IIOPAddress iaddr = new IIOPAddress();
            iaddr.configure(this.configuration);
            String ipaddr = addr.toString().substring(1);
            if (addr instanceof Inet4Address) {
                iaddr.fromString(ipaddr + ":" + this.primaryAddress.getPort());
            } else if (addr instanceof Inet6Address) {
                iaddr.fromString("[" + ipaddr + "]:" + this.primaryAddress.getPort());
            }
            if (iaddr.getIP().equals(primaryIP)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("components.addComponent: adding addrHostAddress <" + iaddr.getHostName() + "> as TAG_ALTERNATE_IIOP_ADDRESS");
            }
            this.checkAlternateAddresses = true;
            this.components.addComponent(3, iaddr.toCDR());
        }
    }

    @Override
    public void writeAddressProfile(CDROutputStream addressProfileStream) {
        VersionHelper.write((OutputStream)addressProfileStream, (Version)this.version);
        this.primaryAddress.write(addressProfileStream);
    }

    @Override
    public void readAddressProfile(CDRInputStream addressProfileStream) {
        this.version = VersionHelper.read((InputStream)addressProfileStream);
        String hostname = addressProfileStream.read_string();
        short port = addressProfileStream.read_ushort();
        this.primaryAddress = new IIOPAddress(hostname, port);
        if (this.configuration != null) {
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ex) {
                this.logger.error("Error configuring address", (Throwable)ex);
                throw new INTERNAL("Error configuring address" + ex);
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile result = (IIOPProfile)super.clone();
        result.primaryAddress = new IIOPAddress(this.primaryAddress.getHostName(), this.primaryAddress.getPort());
        if (this.configuration != null) {
            try {
                result.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ex) {
                this.logger.error("Error configuring address", (Throwable)ex);
                throw new INTERNAL("Error configuring address" + ex);
            }
        }
        result.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            result.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, result.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            result.components = (TaggedComponentList)this.components.clone();
        }
        return result;
    }

    public boolean is_match(Profile prof) {
        if (prof == null) {
            return false;
        }
        if (prof instanceof IIOPProfile) {
            IIOPProfile other = (IIOPProfile)prof;
            return this.getSSLPort() == other.getSSLPort() && this.primaryAddress.equals(other.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(other.getAlternateAddresses());
        }
        return false;
    }

    @Override
    public int tag() {
        return 0;
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    @Override
    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
        if (replacement instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)replacement);
        }
    }

    public List<IIOPAddress> getAlternateAddresses() {
        if (this.checkAlternateAddresses) {
            return this.components.getComponents(this.configuration, 3, IIOPAddress.class);
        }
        return Collections.emptyList();
    }

    public SSL getSSL() {
        if (!this.isSSLSet) {
            this.ssl = (SSL)this.components.getComponent(20, SSLHelper.class);
            this.isSSLSet = true;
        }
        return this.ssl;
    }

    public int getSSLPort() {
        TLS_SEC_TRANS tls = this.getTlsSpecFromCSIComponent();
        if (tls != null && tls.addresses.length > 0) {
            return IIOPProfile.adjustedPortNum(tls.addresses[0].port);
        }
        this.getSSL();
        if (this.ssl != null) {
            return IIOPProfile.adjustedPortNum(this.ssl.port);
        }
        return -1;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile result = new IIOPProfile(this.primaryAddress, this.objectKey, 0);
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof Profile && this.is_match((Profile)other);
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    int getSslPortIfSupported(int client_required, int client_supported) {
        TLS_SEC_TRANS tls = this.getTlsSpecFromCSIComponent();
        SSL ssl = (SSL)this.getComponent(20, SSLHelper.class);
        if (tls != null && this.useSsl(client_supported, client_required, tls.target_supports, tls.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            return IIOPProfile.adjustedPortNum(tls.addresses[0].port);
        }
        if (ssl != null && this.useSsl(client_supported, client_required, ssl.target_supports, ssl.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
            return IIOPProfile.adjustedPortNum(ssl.port);
        }
        if ((client_required & 0x7E) != 0) {
            throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
        }
        return -1;
    }

    private static int adjustedPortNum(short port) {
        return port < 0 ? port + 65536 : port;
    }

    private boolean useSsl(int clientSupports, int clientRequires, short targetSupports, short targetRequires) {
        return (targetSupports & 0x7E) != 0 && (clientSupports & 0x7E) != 0 && ((targetRequires & 0x7E) != 0 || (clientRequires & 0x7E) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLS_SEC_TRANS getTlsSpecFromCSIComponent() {
        CompoundSecMechList sas = null;
        try {
            sas = (CompoundSecMechList)this.getComponent(33, CompoundSecMechListHelper.class);
        }
        catch (Exception ex) {
            this.logger.info("Not able to process security mech. component");
        }
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
                CDRInputStream in = new CDRInputStream(tagData);
                try {
                    in.openEncapsulatedArray();
                    tls = TLS_SEC_TRANSHelper.read((InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + e);
            }
        }
        return tls;
    }

    @Override
    public Collection<ListenPoint> asListenPoints() {
        ArrayList<ListenPoint> result = new ArrayList<ListenPoint>();
        if (this.getSSL() == null) {
            result.add(new ListenPoint(this.primaryAddress.getHostName(), (short)this.primaryAddress.getPort()));
        } else if (this.getSSLPort() == 0) {
            result.add(new ListenPoint(this.primaryAddress.getHostName(), (short)this.primaryAddress.getPort()));
        } else {
            result.add(new ListenPoint(this.primaryAddress.getHostName(), (short)this.getSSLPort()));
        }
        for (IIOPAddress addr : this.getAlternateAddresses()) {
            result.add(new ListenPoint(addr.getHostName(), (short)addr.getPort()));
        }
        return result;
    }

    public IIOPProfile toNonSSL() {
        assert (this.getSSL() != null);
        IIOPAddress address = null;
        IIOPProfile result = null;
        try {
            address = new IIOPAddress(this.primaryAddress.getHostName(), this.getSSLPort());
            address.configure(this.configuration);
            result = new IIOPProfile(address, this.objectKey, this.configuration.getORB().getGIOPMinorVersion());
            result.configure(this.configuration);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Error configuring address", (Throwable)ex);
            throw new INTERNAL("Error configuring address" + ex);
        }
        TaggedComponent[] taggedComponents = this.components.asArray();
        for (int i = 0; i < taggedComponents.length; ++i) {
            if (taggedComponents[i].tag == 20) continue;
            result.components.addComponent(taggedComponents[i]);
        }
        return result;
    }
}

