/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.ArrayList;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.CodeSet;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.miop.MulticastUtil;
import org.jacorb.util.Time;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.PrincipalHelper;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.TimeBase.UtcT;

public class RequestOutputStream
extends ServiceContextTransportingOutputStream {
    private static final byte[] principal = new byte[0];
    private static final byte[] reserved = new byte[3];
    private final int request_id;
    private final boolean response_expected;
    private final short syncScope;
    private final String operation;
    private final UtcT requestStartTime;
    private final UtcT requestEndTime;
    private final UtcT replyEndTime;
    private Request request = null;
    private final ClientConnection connection;
    private final byte[] object_key;

    public RequestOutputStream(RequestOutputStream other) {
        super((org.omg.CORBA.ORB)other.orb);
        this.object_key = other.object_key;
        this.request_id = other.request_id;
        this.response_expected = other.response_expected;
        this.syncScope = other.syncScope;
        this.operation = other.operation;
        this.connection = other.connection;
        this.requestStartTime = other.requestStartTime;
        this.requestEndTime = other.requestEndTime;
        this.replyEndTime = other.replyEndTime;
        this.contexts = other.contexts;
        this.header_end = other.header_end;
        this.header_padding = other.header_padding;
        this.giop_minor = other.giop_minor;
        byte[] copy = other.getBufferCopy();
        this.write_octet_array(copy, 0, copy.length);
    }

    public RequestOutputStream(ORB orb, ClientConnection connection, int request_id, String operation, boolean response_expected, short syncScope, UtcT requestStartTime, UtcT requestEndTime, UtcT replyEndTime, byte[] object_key, int giop_minor) {
        super((org.omg.CORBA.ORB)orb);
        this.setGIOPMinor(giop_minor);
        this.object_key = object_key;
        this.request_id = request_id;
        this.response_expected = response_expected;
        this.syncScope = syncScope;
        this.operation = operation;
        this.connection = connection;
        this.requestStartTime = requestStartTime;
        this.requestEndTime = requestEndTime;
        this.replyEndTime = replyEndTime;
        if (requestStartTime != null || requestEndTime != null || replyEndTime != null) {
            this.addServiceContext(this.createInvocationPolicies());
        }
        this.writeGIOPMsgHeader(0, giop_minor);
        boolean isMIOP = connection != null && connection.getRegisteredProfile() instanceof MIOPProfile;
        switch (giop_minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write((OutputStream)this, (ServiceContext[])Messages.service_context);
                this.write_ulong(request_id);
                this.write_boolean(response_expected);
                if (giop_minor == 1) {
                    this.write_octet_array(reserved, 0, 3);
                }
                if (isMIOP) {
                    this.write_char_array(MulticastUtil.MAGIC, 0, MulticastUtil.MAGIC.length);
                    this.write_long(3);
                    this.beginEncapsulation();
                    UIPMC_ProfileBodyHelper.write((OutputStream)this, (UIPMC_ProfileBody)((MIOPProfile)connection.getRegisteredProfile()).getUIPMCProfile());
                    this.endEncapsulation();
                } else {
                    this.write_long(object_key.length);
                    this.write_octet_array(object_key, 0, object_key.length);
                }
                this.write_string(operation);
                PrincipalHelper.write((OutputStream)this, (byte[])principal);
                break;
            }
            case 2: {
                TargetAddress addr = new TargetAddress();
                if (isMIOP) {
                    TaggedProfile uipmc = new TaggedProfile(3, MulticastUtil.getEncapsulatedUIPMCProfile(orb, connection));
                    addr.profile(uipmc);
                } else {
                    addr.object_key(object_key);
                }
                this.write_ulong(request_id);
                if (response_expected) {
                    this.write_octet((byte)3);
                } else {
                    switch (syncScope) {
                        case 0: 
                        case 1: {
                            this.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            this.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            this.write_octet((byte)3);
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid SYNC_SCOPE: " + syncScope);
                        }
                    }
                }
                this.write_octet_array(reserved, 0, 3);
                TargetAddressHelper.write((OutputStream)this, (TargetAddress)addr);
                this.write_string(operation);
                ServiceContextListHelper.write((OutputStream)this, (ServiceContext[])Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + giop_minor);
            }
        }
    }

    public int requestId() {
        return this.request_id;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public short syncScope() {
        return this.syncScope;
    }

    public String operation() {
        return this.operation;
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public void write_to(GIOPConnection conn) throws IOException {
        if (!conn.isTCSNegotiated()) {
            this.addServiceContext(this.createCodesetContext(conn.getTCS(), conn.getTCSW()));
            conn.markTCSNegotiated();
        }
        super.write_to(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext createCodesetContext(CodeSet tcs, CodeSet tcsw) {
        CDROutputStream os = new CDROutputStream((org.omg.CORBA.ORB)this.orb);
        try {
            os.beginEncapsulatedArray();
            CodeSetContextHelper.write((OutputStream)os, (CodeSetContext)new CodeSetContext(tcs.getId(), tcsw.getId()));
            ServiceContext serviceContext = new ServiceContext(1, os.getBufferCopy());
            return serviceContext;
        }
        finally {
            os.close();
        }
    }

    private PolicyValue[] getTimingPolicyValues() {
        ArrayList<PolicyValue> list = new ArrayList<PolicyValue>();
        if (this.requestStartTime != null) {
            list.add(new PolicyValue(27, Time.toCDR(this.requestStartTime)));
        }
        if (this.requestEndTime != null) {
            list.add(new PolicyValue(28, Time.toCDR(this.requestEndTime)));
        }
        if (this.replyEndTime != null) {
            list.add(new PolicyValue(30, Time.toCDR(this.replyEndTime)));
        }
        return list.toArray(new PolicyValue[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext createInvocationPolicies() {
        CDROutputStream out = new CDROutputStream((org.omg.CORBA.ORB)this.orb);
        try {
            out.beginEncapsulatedArray();
            PolicyValueSeqHelper.write((OutputStream)out, (PolicyValue[])this.getTimingPolicyValues());
            ServiceContext serviceContext = new ServiceContext(7, out.getBufferCopy());
            return serviceContext;
        }
        finally {
            out.close();
        }
    }
}

