/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.jacorb.naming.namemanager.Handler;
import org.jacorb.naming.namemanager.NSTable;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.naming.namemanager.TableHandler;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class NameManager {
    public static void main(String[] args) {
        ORB orb = ORB.init((String[])args, null);
        JFrame frame = new JFrame("JacORB NameManager");
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem quit = new JMenuItem("Quit", 81);
        quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        fileMenu.add(quit);
        JMenuItem options = new JMenuItem("Options");
        JMenuItem create = new JMenuItem("BindNewContext", 78);
        create.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        JMenuItem bindObject = new JMenuItem("Bind Object", 66);
        bindObject.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        JMenuItem unbind = new JMenuItem("Unbind name", 85);
        unbind.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        editMenu.add(options);
        editMenu.add(create);
        editMenu.add(bindObject);
        editMenu.add(unbind);
        JMenuItem about = new JMenuItem("About...");
        helpMenu.add(about);
        menubar.add(fileMenu);
        menubar.add(editMenu);
        menubar.add(helpMenu);
        NamingContext rootContext = null;
        try {
            rootContext = NamingContextHelper.narrow((Object)orb.resolve_initial_references("NameService"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Could not find name service", "Initialization error", 0);
            NameManager.usage();
            System.exit(1);
        }
        if (rootContext == null) {
            System.err.println("Narrow for name service failed, exiting...");
            NameManager.usage();
            System.exit(1);
        }
        NSTable nstable = new NSTable();
        JScrollPane tableScrollPane = new JScrollPane(nstable);
        nstable.setPreferredScrollableViewportSize(new Dimension(300, 250));
        NSTree tree = new NSTree(300, 200, nstable, rootContext, orb);
        JScrollPane treeScrollPane = new JScrollPane(tree);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(treeScrollPane);
        splitPane.setRightComponent(tableScrollPane);
        splitPane.setDividerLocation(200);
        splitPane.setDividerSize(2);
        frame.getContentPane().setBackground(Color.white);
        frame.getContentPane().add(splitPane);
        tree.update();
        Handler handler = new Handler(frame, tree);
        TableHandler tableHandler = new TableHandler(frame, nstable);
        quit.addActionListener(handler);
        options.addActionListener(handler);
        create.addActionListener(handler);
        bindObject.addActionListener(handler);
        unbind.addActionListener(handler);
        about.addActionListener(handler);
        tree.addMouseListener(handler);
        tree.addKeyListener(handler);
        frame.addWindowListener(handler);
        nstable.addMouseListener(tableHandler);
        nstable.addKeyListener(tableHandler);
        frame.setJMenuBar(menubar);
        frame.pack();
        frame.show();
        orb.run();
    }

    public static void usage() {
        System.out.println("Usage: NameManager [orb_options]");
        System.out.println("          e.g. nmg -ORBInitRef NameService=file:///c:/ns.ior");
    }
}

