/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jacorb.imr.util.ImRModel;

public class RefreshWindow
extends JFrame
implements ActionListener {
    private JTextField m_interval_tf;
    private JButton m_ok_btn;
    private JButton m_cancel_btn;
    private Checkbox m_disable_box;
    private ImRModel m_model;

    public RefreshWindow(ImRModel model) {
        super("Refresh Interval Settings");
        this.m_model = model;
        JPanel _interval_panel = new JPanel();
        GridBagLayout _interval_gbl = new GridBagLayout();
        GridBagConstraints _constraints = new GridBagConstraints();
        JLabel _interval_lbl = new JLabel("Enter an Interval (in ms):");
        this.buildConstraints(_constraints, 0, 0, 1, 1, 1, 1);
        _constraints.fill = 0;
        _interval_gbl.setConstraints(_interval_lbl, _constraints);
        _interval_panel.add(_interval_lbl);
        this.m_interval_tf = new JTextField("" + this.m_model.m_current_refresh_interval, 10);
        this.buildConstraints(_constraints, 0, 1, 2, 1, 1, 1);
        _constraints.fill = 2;
        _interval_gbl.setConstraints(this.m_interval_tf, _constraints);
        _interval_panel.add(this.m_interval_tf);
        this.m_disable_box = new Checkbox("Disable automatic refresh");
        this.m_disable_box.setState(this.m_model.m_refresh_disabled);
        this.buildConstraints(_constraints, 0, 2, 2, 1, 1, 1);
        _constraints.fill = 2;
        _interval_gbl.setConstraints(this.m_disable_box, _constraints);
        _interval_panel.add(this.m_disable_box);
        this.m_ok_btn = new JButton("OK");
        this.m_ok_btn.addActionListener(this);
        this.buildConstraints(_constraints, 0, 3, 1, 1, 1, 1);
        _constraints.fill = 0;
        _interval_gbl.setConstraints(this.m_ok_btn, _constraints);
        _interval_panel.add(this.m_ok_btn);
        this.m_cancel_btn = new JButton("Cancel");
        this.m_cancel_btn.addActionListener(this);
        this.buildConstraints(_constraints, 1, 3, 1, 1, 1, 1);
        _constraints.fill = 0;
        _interval_gbl.setConstraints(this.m_cancel_btn, _constraints);
        _interval_panel.add(this.m_cancel_btn);
        _interval_panel.setLayout(_interval_gbl);
        this.getContentPane().add(_interval_panel);
        this.pack();
        this.setVisible(true);
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton _source = (JButton)event.getSource();
        if (_source == this.m_cancel_btn) {
            this.dispose();
        } else if (_source == this.m_ok_btn) {
            this.dispose();
            if (this.m_disable_box.getState()) {
                this.m_model.disableRefresh();
            } else {
                this.m_model.setRefreshInterval(Integer.parseInt(this.m_interval_tf.getText()));
            }
        }
    }
}

