package jp.naist.se.stigmata.ui.swing;

/*
 * $Id: ClassNameObfuscator.java 140 2007-06-28 10:48:47Z tama3 $
 */

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkSet;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 140 $ $Date: 2007-06-28 19:48:47 +0900 (Thu, 28 Jun 2007) $
 */
public class ClassNameObfuscator{
    private Map<String, String> nameMapping = new HashMap<String, String>();

    public void outputNameMappings(File file) throws IOException{
        PrintWriter out = null;
        try{
            out = new PrintWriter(new FileWriter(file));
            for(String oldName: nameMapping.keySet()){
                String newName = nameMapping.get(oldName);
                out.print(oldName);
                out.print(",");
                out.println(newName);
            }

        }finally{
            if(out != null){
                out.close();
            }
        }
    }

    public BirthmarkSet obfuscateClassName(BirthmarkSet orig){
        String newName = nameMapping.get(orig.getName());
        if(newName == null){
            newName = String.format("C%04d", new Object[] { new Integer(nameMapping.size() + 1), });
            nameMapping.put(orig.getName(), newName);
        }

        BirthmarkSet newSet = new BirthmarkSet(newName, orig.getLocation());
        for(Birthmark birthmark: orig){
            newSet.addBirthmark(birthmark);
        }
        return newSet;
    }

}
