package jp.naist.se.stigmata;

/*
 * $Id: ComparisonPairElement.java 173 2007-07-16 02:24:32Z tama3 $
 */

/**
 * This class represents comparing two birthmarks.
 * @author  Haruaki TAMADA
 * @version  $Revision: 173 $ $Date: 2007-07-16 11:24:32 +0900 (Mon, 16 Jul 2007) $
 */
public class ComparisonPairElement{
    private Birthmark birthmark1;
    private Birthmark birthmark2;
    private BirthmarkComparator comparator;
    private double similarity;
    private int compareCount = -1;

    public ComparisonPairElement(Birthmark birthmark1, Birthmark birthmark2,
            BirthmarkComparator comparator){
        this.birthmark1 = birthmark1;
        this.birthmark2 = birthmark2;
        this.comparator = comparator;

        if(!birthmark1.getType().equals(birthmark2.getType())){
            throw new IllegalArgumentException("birthmark type mismatch");
        }
        // cached
        similarity = comparator.compare(birthmark1, birthmark2);
    }

    public synchronized int getComparisonCount(){
        // cached
        if(compareCount < 0){
            compareCount = comparator.getCompareCount(birthmark1, birthmark2);
        }
        return compareCount;
    }

    public String getType(){
        return birthmark1.getType();
    }

    /**
     * @return  similarity
     */
    public double getSimilarity(){
        return similarity;
    }
}
