/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.format.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.format.AbstractBirthmarkExtractionResultFormat;

public class BirthmarkExtractionListXmlFormat
extends AbstractBirthmarkExtractionResultFormat {
    public void printResult(PrintWriter out, BirthmarkSet[] holders) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark>");
        out.println("  <extracted-birthmarks>");
        int i = 0;
        while (i < holders.length) {
            this.printBirthmarkHolder(out, holders[i]);
            ++i;
        }
        out.println("  </extracted-birthmarks>");
        out.println("</birthmark>");
    }

    protected void printBirthmarkHolder(PrintWriter out, BirthmarkSet set) {
        out.println("    <extracted-birthmark>");
        out.printf("      <class-name>%s</class-name>%n", this.escapeToXmlString(set.getName()));
        out.printf("      <location>%s</location>%n", this.escapeToXmlString(set.getLocation()));
        Iterator<String> i = set.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark birthmark = set.getBirthmark(type);
            out.printf("      <birthmark type=\"%s\" count=\"%d\">%n", birthmark.getType(), birthmark.getElementCount());
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.printf("        <element>%s</element>%n", this.escapeToXmlString(String.valueOf(elements.next())));
            }
            out.println("      </birthmark>");
        }
        out.println("    </extracted-birthmark>");
    }

    public String escapeToXmlString(Object o) {
        if (o != null) {
            return this.escapeToXmlString(o.toString());
        }
        return null;
    }

    public String escapeToXmlString(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

