/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import java.lang.reflect.Constructor;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.AbstractBirthmarkService;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class BirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private Class<? extends BirthmarkExtractor> extractorClass;
    private Class<? extends BirthmarkComparator> comparatorClass;
    private String type;
    private String displayType;
    private String description;
    private BirthmarkExtractor extractorObject;
    private BirthmarkComparator comparatorObject;
    private boolean userDefined = true;
    private BirthmarkContext context;

    public BirthmarkService(BirthmarkContext context) {
        this.context = context;
    }

    public BirthmarkService() {
    }

    public void setBirthmarkContext(BirthmarkContext context) {
        this.context = context;
    }

    public void setExtractorClassName(String extractor) {
        try {
            Class<?> c = this.context == null ? Class.forName(extractor) : this.context.getBytecodeContext().findClass(extractor);
            this.extractorClass = c.asSubclass(BirthmarkExtractor.class);
            this.extractorObject = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setComparatorClassName(String comparator) {
        try {
            Class<?> c = this.context == null ? Class.forName(comparator) : this.context.getBytecodeContext().findClass(comparator);
            this.comparatorClass = c.asSubclass(BirthmarkComparator.class);
            this.comparatorObject = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        String desc = this.description;
        if (this.description == null) {
            desc = "";
        }
        return desc;
    }

    public String getDefaultDescription() {
        return this.description;
    }

    public String getExtractorClassName() {
        return this.extractorClass.getName();
    }

    public BirthmarkExtractor getExtractor() {
        if (this.extractorObject == null) {
            try {
                Constructor<? extends BirthmarkExtractor> c = this.extractorClass.getConstructor(BirthmarkSpi.class);
                this.extractorObject = c.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.extractorObject;
    }

    public String getComparatorClassName() {
        return this.comparatorClass.getName();
    }

    public BirthmarkComparator getComparator() {
        if (this.comparatorObject == null) {
            try {
                Constructor<? extends BirthmarkComparator> c = this.comparatorClass.getConstructor(BirthmarkSpi.class);
                this.comparatorObject = c.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.comparatorObject;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }
}

