/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.filter.BirthmarkElementCountComparisonPairFilter;
import jp.naist.se.stigmata.filter.BirthmarkElementCountComparisonPairFilterService;
import jp.naist.se.stigmata.filter.Target;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListCellRenderer;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class BirthmarkElementCountComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService
implements BirthmarkServiceListener {
    private Pane pane;

    public ComparisonPairFilterPane createComponent(ComparisonPairFilterSpi service) {
        this.pane = new Pane(service);
        return this.pane;
    }

    public String getFilterName() {
        return "elementcount";
    }

    public void serviceAdded(BirthmarkSpi service) {
        this.pane.serviceAdded(service);
    }

    public void serviceRemoved(BirthmarkSpi service) {
        this.pane.serviceRemoved(service);
    }

    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new BirthmarkElementCountComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane
    implements BirthmarkServiceListener {
        private static final long serialVersionUID = -6398073942592186671L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;
        private JComboBox targetType;
        private JComboBox birthmarks;

        public Pane(ComparisonPairFilterSpi service) {
            this.service = service;
            this.initLayouts();
        }

        public void serviceAdded(BirthmarkSpi service) {
            this.birthmarks.addItem(service);
        }

        public void serviceRemoved(BirthmarkSpi service) {
            this.birthmarks.removeItem(service);
        }

        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(Messages.getString("error.empty.threshold"));
            }
            try {
                int v = Integer.parseInt(this.threshold.getText());
                if (v < 0) {
                    errors.add(Messages.getString("error.negative.value", v));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getString("error.invalid.format.integer", this.threshold.getText()));
            }
            return errors.toArray(new String[errors.size()]);
        }

        public ComparisonPairFilter getFilter() {
            try {
                BirthmarkElementCountComparisonPairFilter filter = new BirthmarkElementCountComparisonPairFilter(this.service);
                filter.setBirthmarkType(this.getBirthmarkType());
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setThreshold(Integer.parseInt(this.threshold.getText()));
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(Target.BOTH_TARGET));
        }

        public void setFilter(ComparisonPairFilter cpf) {
            BirthmarkElementCountComparisonPairFilter filter = (BirthmarkElementCountComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.threshold.setText(String.valueOf(filter.getThreshold()));
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(Messages.getString("filter.elementcount.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(BirthmarkElementCountComparisonPairFilter.getValidCriteria());
            this.birthmarks = new JComboBox();
            this.birthmarks.setRenderer(new BirthmarkServiceListCellRenderer(new Dimension(200, 20), 60));
            JLabel label2 = new JLabel(Messages.getString("filter.elementcount.label.next"));
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(6, 1));
            this.add(label);
            this.add(this.birthmarks);
            this.add(label2);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.threshold);
        }

        private String getBirthmarkType() {
            BirthmarkSpi service = (BirthmarkSpi)this.birthmarks.getSelectedItem();
            if (service != null) {
                return service.getType();
            }
            throw new IllegalStateException("invalid birthmarks");
        }
    }
}

