/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkDataWritable;
import jp.naist.se.stigmata.ui.swing.ClassNameObfuscator;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class RoundRobinComparisonResultPane
extends JPanel
implements BirthmarkDataWritable {
    private static final long serialVersionUID = 2134574576543623L;
    private BirthmarkSet[] birthmarksX;
    private BirthmarkSet[] birthmarksY;
    private JTable table;
    private DefaultTableModel model;
    private JLabel classCount;
    private JLabel comparisonCount;
    private JLabel distinctionRatio;
    private JLabel average;
    private JLabel minimum;
    private JLabel maximum;
    private StigmataFrame stigmataFrame;
    private BirthmarkContext context;

    public RoundRobinComparisonResultPane(StigmataFrame stigmata, BirthmarkContext context, BirthmarkSet[] birthmarksX, BirthmarkSet[] birthmarksY) {
        this.stigmataFrame = stigmata;
        this.context = context;
        this.birthmarksX = birthmarksX;
        this.birthmarksY = birthmarksY;
        this.initialize();
        this.compare(this.model);
    }

    public void writeData(PrintWriter out, ResultFormatSpi service) {
        service.getComparisonResultFormat().printResult(out, new RoundRobinComparisonResultSet(this.birthmarksX, this.birthmarksY, this.context));
    }

    private void compare(DefaultTableModel model) {
        int comparison = this.birthmarksX.length * this.birthmarksY.length;
        this.classCount.setText(Integer.toString(this.birthmarksX.length + this.birthmarksY.length));
        this.comparisonCount.setText(Integer.toString(comparison));
        int correct = 0;
        double avg = 0.0;
        double max = 0.0;
        double min = 100.0;
        model.addColumn("");
        for (BirthmarkSet x : this.birthmarksX) {
            model.addColumn(x.getClassName());
        }
        for (int j = 0; j < this.birthmarksY.length; ++j) {
            Object[] rows = new Object[this.birthmarksX.length + 1];
            rows[0] = this.birthmarksY[j].getClassName();
            for (int i = 0; i < this.birthmarksX.length; ++i) {
                double similarity = this.compare(this.context, this.birthmarksX[i], this.birthmarksY[j]);
                rows[i + 1] = new Double(similarity);
                if (Math.abs(similarity - 1.0) < 1.0E-8) {
                    ++correct;
                }
                avg += similarity;
                if (max < similarity) {
                    max = similarity;
                }
                if (!(min > similarity)) continue;
                min = similarity;
            }
            model.addRow(rows);
        }
        this.distinctionRatio.setText(Double.toString((double)(comparison - correct) / (double)comparison));
        this.average.setText(Double.toString(avg /= (double)comparison));
        this.minimum.setText(Double.toString(min));
        this.maximum.setText(Double.toString(max));
    }

    private double compare(BirthmarkContext context, BirthmarkSet x, BirthmarkSet y) {
        double similarity = 0.0;
        int count = 0;
        for (String type : x.getBirthmarkTypes()) {
            BirthmarkComparator comparator;
            double result;
            Birthmark b1 = x.getBirthmark(type);
            Birthmark b2 = y.getBirthmark(type);
            if (b1 == null || b2 == null || (result = (comparator = context.getService(type).getComparator()).compare(b1, b2)) == Double.NaN) continue;
            similarity += result;
            ++count;
        }
        return similarity / (double)count;
    }

    private Component getMainPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.model = new RoundRobinComparisonResultSetTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = RoundRobinComparisonResultPane.this.table.rowAtPoint(e.getPoint());
                    int col = RoundRobinComparisonResultPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < RoundRobinComparisonResultPane.this.table.getColumnCount() && row >= 0 && row < RoundRobinComparisonResultPane.this.table.getRowCount()) {
                        BirthmarkSet b1 = RoundRobinComparisonResultPane.this.birthmarksX[col - 1];
                        BirthmarkSet b2 = RoundRobinComparisonResultPane.this.birthmarksY[row];
                        RoundRobinComparisonResultPane.this.stigmataFrame.compareDetails(b1, b2, RoundRobinComparisonResultPane.this.context);
                    }
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        scroll.setWheelScrollingEnabled(true);
        panel.add((Component)scroll, "Center");
        Box south = Box.createVerticalBox();
        JPanel box1 = new JPanel(new GridLayout(1, 3));
        this.classCount = new JLabel();
        box1.add(this.classCount);
        this.comparisonCount = new JLabel();
        box1.add(this.comparisonCount);
        this.distinctionRatio = new JLabel();
        box1.add(this.distinctionRatio);
        south.add(box1);
        JPanel box2 = new JPanel(new GridLayout(1, 3));
        box2.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        this.average = new JLabel();
        box2.add(this.average);
        this.minimum = new JLabel();
        box2.add(this.minimum);
        this.maximum = new JLabel();
        box2.add(this.maximum);
        south.add(box2);
        this.classCount.setBorder(new TitledBorder(Messages.getString("numberofclasses.border")));
        this.comparisonCount.setBorder(new TitledBorder(Messages.getString("comparisoncount.border")));
        this.distinctionRatio.setBorder(new TitledBorder(Messages.getString("distinctionratio.border")));
        this.average.setBorder(new TitledBorder(Messages.getString("average.border")));
        this.minimum.setBorder(new TitledBorder(Messages.getString("minimum.border")));
        this.maximum.setBorder(new TitledBorder(Messages.getString("maximum.border")));
        panel.add((Component)south, "South");
        return panel;
    }

    private void saveButtonActionPerformed(ActionEvent e) {
        this.stigmataFrame.saveAction(this);
    }

    private void graphButtonActionPerformed(ActionEvent e) {
        HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 1; j < this.table.getColumnCount(); ++j) {
                Double d = (Double)this.table.getValueAt(i, j);
                int similarity = (int)Math.round(d * 100.0);
                Integer dist = (Integer)values.get(new Integer(similarity));
                if (dist == null) {
                    dist = new Integer(0);
                }
                dist = new Integer(dist + 1);
                values.put(new Integer(similarity), dist);
            }
        }
        this.stigmataFrame.showGraph(values);
    }

    private void initialize() {
        JButton save = Utility.createButton("savecomparison");
        JButton graph = Utility.createButton("showgraph");
        JButton obfuscate = Utility.createButton("obfuscate");
        JButton compare = Utility.createButton("compare");
        final JComboBox<String> combo = new JComboBox<String>();
        Box southPanel = Box.createHorizontalBox();
        String[] comparisonMethods = Messages.getStringArray("comparison.methods.inroundrobinresult");
        for (int i = 0; i < comparisonMethods.length; ++i) {
            combo.addItem(comparisonMethods[i]);
        }
        this.setLayout(new BorderLayout());
        this.add(this.getMainPane(), "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(save);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(graph);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(obfuscate);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(compare);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(combo);
        southPanel.add(Box.createHorizontalGlue());
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.saveButtonActionPerformed(e);
            }
        });
        graph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.graphButtonActionPerformed(e);
            }
        });
        obfuscate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.obfuscateClassNames();
            }
        });
        compare.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)combo.getSelectedItem();
                if (item.equals(Messages.getString("guessedpair.label"))) {
                    RoundRobinComparisonResultPane.this.compareGuessedPair();
                } else if (item.equals(Messages.getString("specifiedpair.label"))) {
                    RoundRobinComparisonResultPane.this.compareSpecifiedPair();
                }
            }
        });
    }

    private void compareGuessedPair() {
        CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(this.birthmarksX, this.birthmarksY, this.context);
        this.stigmataFrame.showComparisonResultSet(resultset);
    }

    private void compareSpecifiedPair() {
        File file = this.stigmataFrame.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.stigmataFrame.constructMapping(file);
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(this.birthmarksX, this.birthmarksY, mapping, this.context);
            this.stigmataFrame.showComparisonResultSet(resultset);
        }
    }

    private void obfuscateClassNames() {
        int i;
        ClassNameObfuscator obfuscator = new ClassNameObfuscator();
        for (i = 0; i < this.birthmarksX.length; ++i) {
            this.birthmarksX[i] = obfuscator.obfuscateClassName(this.birthmarksX[i]);
        }
        for (i = 0; i < this.birthmarksY.length; ++i) {
            this.birthmarksY[i] = obfuscator.obfuscateClassName(this.birthmarksY[i]);
        }
        try {
            File file = this.stigmataFrame.getSaveFile(Messages.getStringArray("obfuscationmapping.extension"), Messages.getString("obfuscationmapping.description"));
            obfuscator.outputNameMappings(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("error.dialog.title"), 0);
            return;
        }
        RoundRobinComparisonResultSetTableModel model = new RoundRobinComparisonResultSetTableModel();
        this.compare(model);
        this.table.setModel(model);
        this.model = model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoundRobinComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 765435324523543242L;

        private RoundRobinComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            return Double.class;
        }
    }
}

