/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.Iterator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinComparisonResultSet
implements ComparisonResultSet {
    private BirthmarkSet[] holders1;
    private BirthmarkSet[] holders2;
    private BirthmarkContext context;
    private int compareCount;
    private boolean tablePair = true;
    private boolean samePair = false;

    public RoundRobinComparisonResultSet(BirthmarkSet[] holders1, BirthmarkContext context) {
        this(holders1, context, false);
    }

    public RoundRobinComparisonResultSet(BirthmarkSet[] holders1, BirthmarkContext context, boolean samePair) {
        this.holders1 = holders1;
        this.holders2 = holders1;
        this.context = context;
        this.tablePair = false;
        this.setCompareSamePair(samePair);
    }

    public RoundRobinComparisonResultSet(BirthmarkSet[] holders1, BirthmarkSet[] holders2, BirthmarkContext context) {
        this.holders1 = holders1;
        this.holders2 = holders2;
        this.context = context;
        this.tablePair = true;
        this.compareCount = holders1.length * holders2.length;
    }

    @Override
    public BirthmarkContext getContext() {
        return this.context;
    }

    public void setCompareSamePair(boolean flag) {
        this.samePair = flag;
        this.compareCount = this.samePair ? this.holders1.length * (this.holders1.length + 1) / 2 : this.holders1.length * (this.holders1.length - 1) / 2;
    }

    public boolean isCompareSamePair() {
        return this.samePair;
    }

    @Override
    public int getComparisonCount() {
        return this.compareCount;
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return new ComparisonIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComparisonIterator
    implements Iterator<ComparisonPair> {
        private int i = 0;
        private int j = 0;
        private int count = 0;

        private ComparisonIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < RoundRobinComparisonResultSet.this.getComparisonCount();
        }

        @Override
        public ComparisonPair next() {
            if (RoundRobinComparisonResultSet.this.tablePair && this.i == RoundRobinComparisonResultSet.this.holders1.length || !RoundRobinComparisonResultSet.this.tablePair && !RoundRobinComparisonResultSet.this.samePair && this.i == this.j || !RoundRobinComparisonResultSet.this.tablePair && RoundRobinComparisonResultSet.this.samePair && this.i > this.j) {
                this.i = 0;
                ++this.j;
            }
            ComparisonPair pair = new ComparisonPair(RoundRobinComparisonResultSet.this.holders1[this.i], RoundRobinComparisonResultSet.this.holders2[this.j], RoundRobinComparisonResultSet.this.context);
            ++this.count;
            ++this.i;
            return pair;
        }

        @Override
        public void remove() {
        }
    }
}

