package jp.naist.se.stigmata;

/*
 * $Id: ConfigFileParser.java 40 2007-02-19 04:23:35Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import jp.naist.se.stigmata.utils.WellknownClassManager;
import jp.naist.se.stigmata.utils.WellknownClassJudgeRule;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * configuration file parser.
 * @author  Haruaki TAMADA
 * @version  $Revision: 40 $ $Date: 2007-02-19 13:23:35 +0900 (Mon, 19 Feb 2007) $
 */
public class ConfigFileParser extends DefaultHandler{
    private BirthmarkContext context;

    private WellknownClassManager manager;

    private boolean wellknownPart = false;

    private boolean propertyPart = false;

    private boolean classpathPart = false;

    private int wellknownType = 0;

    private int patternType = 0;

    private String qname;

    private String key;

    public ConfigFileParser(BirthmarkContext context){
        this.context = context;
        manager = context.getWellknownClassManager();
    }

    public void parse(InputStream in) throws IOException{
        try{
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, this);
        }
        catch(ParserConfigurationException e){
            throw new IOException(e.getMessage());
        }
        catch(SAXException e){
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName,
                             Attributes attributes) throws SAXException{
        qname = qName;

        if(qName.equals("wellknown-classes")){
            wellknownPart = true;
            propertyPart = false;
            classpathPart = false;
        }
        else if(qName.equals("property")){
            wellknownPart = false;
            propertyPart = true;
            classpathPart = false;
        }
        else if(qName.equals("classpath-list")){
            wellknownPart = false;
            propertyPart = false;
            classpathPart = true;
        }
        else if(qName.equals("exclude")){
            wellknownType = WellknownClassJudgeRule.EXCLUDE_TYPE;
        }
        else if(qName.equals("package")){
            wellknownType = WellknownClassJudgeRule.PACKAGE_TYPE;
        }
        else if(qName.equals("class-name")){
            wellknownType = WellknownClassJudgeRule.CLASS_NAME_TYPE;
        }
        else if(qName.equals("fully-name")){
            wellknownType = WellknownClassJudgeRule.FULLY_TYPE;
        }
        else if(qName.equals("suffix")){
            patternType = WellknownClassJudgeRule.SUFFIX_TYPE;
        }
        else if(qName.equals("prefix")){
            patternType = WellknownClassJudgeRule.PREFIX_TYPE;
        }
        else if(qName.equals("match")){
            patternType = WellknownClassJudgeRule.MATCH_TYPE;
        }
    }

    @Override
    public void characters(char[] data, int offset, int length) throws SAXException{
        String value = new String(data, offset, length).trim();
        if(value.length() > 0){
            if(qname.equals("name") && propertyPart){
                key = new String(data, offset, length).trim();
            }
            else if(qname.equals("value") && propertyPart){
                context.addProperty(key, new String(data, offset, length).trim());
            }
            else if(wellknownPart && (qname.equals("suffix") || qname.equals("prefix") ||
                                      qname.equals("match"))){
                manager.add(new WellknownClassJudgeRule(new String(data, offset, length),
                        wellknownType | patternType));
            }
            else if(classpathPart && qname.equals("classpath")){
                try{
                    context.getBytecodeContext().addClasspath(new URL(value));
                } catch(MalformedURLException e){
                    throw new SAXException(e);
                }
            }
        }
    }
}
