/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;

public class BirthmarkSelectionPane
extends JPanel {
    private static final long serialVersionUID = 3209854654743223453L;
    private StigmataFrame stigmata;
    private List<String> selectedServices = new ArrayList<String>();
    private List<BirthmarkSpi> serviceList = new ArrayList<BirthmarkSpi>();
    private List<JCheckBox> checks = new ArrayList<JCheckBox>();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();

    public BirthmarkSelectionPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initComponents();
    }

    public void select(BirthmarkSpi service, boolean flag) {
        if (flag) {
            this.selectedServices.add(service.getType());
        } else {
            this.selectedServices.remove(service.getType());
        }
        this.fireEvent();
    }

    public void reset() {
        this.selectedServices = new ArrayList<String>();
        for (JCheckBox check : this.checks) {
            check.setSelected(true);
            this.selectedServices.add(check.getText());
        }
        this.fireEvent();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String[] getServices() {
        String[] services = new String[this.serviceList.size()];
        for (int i = 0; i < services.length; ++i) {
            BirthmarkSpi service = this.serviceList.get(i);
            services[i] = service.getType();
        }
        return services;
    }

    public String[] getSelectedServices() {
        return this.selectedServices.toArray(new String[this.selectedServices.size()]);
    }

    private void fireEvent() {
        for (DataChangeListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    private void initComponents() {
        BirthmarkSpi[] services = this.stigmata.getContext().getServices();
        this.setLayout(new GridLayout(1, services.length));
        for (BirthmarkSpi service : services) {
            this.serviceList.add(service);
            JCheckBox check = new JCheckBox(new BirthmarkSelectAction(service, this));
            check.setToolTipText(service.getDescription());
            this.add((Component)check, "Center");
            this.checks.add(check);
        }
        this.reset();
    }

    private static class BirthmarkSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 3209843547654234L;
        private BirthmarkSpi service;
        private BirthmarkSelectionPane birthmarks;

        public BirthmarkSelectAction(BirthmarkSpi service, BirthmarkSelectionPane birthmarks) {
            super(service.getType());
            this.service = service;
            this.birthmarks = birthmarks;
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox check = (JCheckBox)e.getSource();
            this.birthmarks.select(this.service, check.isSelected());
        }
    }
}

