/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands.enums;


/**
 * 
 * After executing the child element, it is an enumerated type who shows as for
 * the execution end of re-execution or the child element of the child element.
 * 
 * @see net.murakmain.sticker.commands.ParentCommand
 * @author Y.Murakamin
 */
public enum PostChildCommandExecutionType
{
	/**
	 * repeat execute
	 */
	REPEAT_EXECUTE,
	/**
	 * end of child element execution
	 */
	NOT_REPEAT;
}
