/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;

import org.apache.commons.lang.StringUtils;

public class TableCommand implements ParentCommand
{

	Commands childlen = new Commands();

	private String name;
	private String optionValue;

	public void addChild(final ExecutableCommand child)
	{
		this.childlen.add(child);
	}

	public void execute(final CommandRunner runner) throws Exception
	{
		PreparedStatement stmt = null;
		try
		{
			ConnectionPool pool = runner.getConnectionPool();

			Connection con = pool.getLocalConnection();
			stmt = con.prepareStatement(this.toString());

			stmt.execute();

			pool.addLocalTableName(this.getName());
			runner.run(this);
		} catch (Exception e)
		{
			throw new CommandExecutionException(this, e);
		} finally
		{
			if (stmt != null)
			{
				stmt.close();
			}
		}
	}

	public Commands getChildlen()
	{
		return this.childlen;
	}

	public String getName()
	{
		return this.name;
	}

	/**
	 * The addition definition of the table (restriction and table constraint
	 * etc. such as primary keys) is acquired in the definition of the table of
	 * the CreateTable sentence.
	 * 
	 * @return The addition definition of the column
	 */
	public String getOption()
	{
		return this.optionValue;
	}

	public VersionTerm getVersionTerm()
	{
		return VersionTerm.PERMANENT_COMMAND;
	}

	public boolean isDebugPrint()
	{
		return true;
	}

	public PostChildCommandExecutionType postChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PostChildCommandExecutionType.NOT_REPEAT;
	}

	public PreChildCommandExecutionType preChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PreChildCommandExecutionType.CHILD_EXECUTE;
	}

	public void setName(final String n)
	{
		this.name = n;
	}

	/**
	 * set the additional value string
	 * 
	 * @param o
	 *            additional value string
	 */
	public void setOption(final String o)
	{
		this.optionValue = o;
	}

	@Override
	public String toString()
	{
		StringBuffer buffer = new StringBuffer("create table ");

		buffer.append(this.getName());
		buffer.append('(');

		for (ExecutableCommand cmd : this.getChildlen())
		{
			if (cmd instanceof ColumnCommand)
			{
				buffer.append(cmd.toString());
				buffer.append(',');
			}
		}

		if (buffer.charAt(buffer.length() - 1) != ')')
		{
			buffer.replace(buffer.length() - 1, buffer.length(), ")");
		} else
		{
			buffer.append(')');
		}

		if (!StringUtils.isEmpty(this.optionValue))
		{
			buffer.append(' ');
			buffer.append(this.getOption());
		}

		return buffer.toString();
	}

}
