/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;

/**
 * Interface that shows command including child element
 * 
 * @author Y.Murakamin
 * 
 */
public interface ParentCommand extends ExecutableCommand
{

	/**
	 * The child element is added.
	 * 
	 * @param child
	 *            the child command
	 */
	void addChild(ExecutableCommand child);

	/**
	 * The list of the child element is acquired.
	 * 
	 * @return The list of the child element is acquired.
	 * @see net.murakamin.sticker.Commands
	 */
	Commands getChildlen();

	/**
	 * Event handler to process it before it begins to execute child element
	 * 
	 * @param runner
	 *            {@link net.murakamin.sticker.CommandRunner} object
	 * @return {@link net.murakamin.sticker.commands.enums.PreChildCommandExecutionType#CHILD_EXECUTE}
	 *         when child element is repeatedly executed.
	 *         {@link net.murakamin.sticker.commands.enums.PreChildCommandExecutionType#CHILD_NOT_EXECUTE}
	 *         when child element is not executed
	 * 
	 * @throws Exception
	 * @see net.murakamin.sticker.commands.enums.PostChildCommandExecutionType
	 */
	PostChildCommandExecutionType postChildCommandExecute(
	        final CommandRunner runner) throws Exception;

	/**
	 * Event handler to process it after execution of child element ends
	 * 
	 * @param runner
	 *            {@link net.murakamin.sticker.CommandRunner} object
	 * @return {@link net.murakamin.sticker.commands.enums.PostChildCommandExecutionType#REPEAT_EXECUTE}
	 *         when child element is continuously executed.{@link net.murakamin.sticker.commands.enums.PostChildCommandExecutionType#NOT_REPEAT}
	 *         when child element is not executed
	 * @throws Exception
	 */
	PreChildCommandExecutionType preChildCommandExecute(
	        final CommandRunner runner) throws Exception;

}
