/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.csv.exception;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

/**
 * Exception generated at CSV Perth process.
 * 
 * @author Y.Murakamin
 * 
 */
public class CSVParseException extends RuntimeException
{

	private static final long serialVersionUID = 8452097775791827667L;

	private int lineNo = -1;

	/**
	 * constractor
	 * 
	 * @param no
	 *            csv processing line number
	 */
	public CSVParseException(final int no)
	{
		super();
		this.lineNo = no;
	}

	/**
	 * constractor
	 * 
	 * @param no
	 *            csv processing line number
	 * @param message
	 *            exception message
	 */
	public CSVParseException(final int no, final String message)
	{
		super(message);
		this.lineNo = no;
	}

	/**
	 * constractor
	 * 
	 * @param no
	 *            csv processing line number
	 * @param message
	 *            exception message
	 * @param cause
	 *            cause object
	 */
	public CSVParseException(final int no, final String message,
	        final Throwable cause)
	{
		super(message, cause);
		this.lineNo = no;
	}

	/**
	 * constractor
	 * 
	 * @param no
	 *            csv processing line number
	 * @param cause
	 *            cause object
	 */
	public CSVParseException(final int no, final Throwable cause)
	{
		super(cause);
		this.lineNo = no;
	}

	/**
	 * constractor
	 * 
	 * @param cause
	 *            cause object
	 */
	public CSVParseException(final Throwable cause)
	{
		super(cause);
	}

	/**
	 * get the csv processing line number
	 * 
	 * @return csv processing line number
	 */
	public int getLineNo()
	{
		return this.lineNo;
	}

	@Override
	public String getLocalizedMessage()
	{
		return this.getMessage();
	}

	@Override
	public String getMessage()
	{
		return Messages.getString("net.murakamin.csv.exception.errormessage") //$NON-NLS-1$
		        + ((this.lineNo == -1) ? ""
		                : Messages
		                        .getString("net.murakamin.csv.exception.errormessage.lineno"))
		        + ((this.lineNo == -1) ? "" : this.lineNo)
		        + SystemUtils.LINE_SEPARATOR
		        + (super.getCause() != null ? Messages
		                .getString("net.murakamin.csv.exception.errorcause") //$NON-NLS-1$
		                + super.getCause().getLocalizedMessage()
		                : StringUtils.EMPTY);
	}
}
