/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import java.util.HashMap;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class Strlen
extends CellProcessorAdaptor
implements StringCellProcessor {
    protected HashMap<Integer, Object> requiredLengths = new HashMap();

    public Strlen(int n, CellProcessor cellProcessor) {
        this(new int[]{n}, cellProcessor);
    }

    public Strlen(int ... nArray) {
        this.addValues(nArray);
    }

    public Strlen(int[] nArray, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.addValues(nArray);
    }

    protected void addValues(int ... nArray) throws SuperCSVException {
        for (int n : nArray) {
            if (n < 0) {
                throw new SuperCSVException("Cannot accept length below 0");
            }
            this.requiredLengths.put(n, null);
        }
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException, ClassCastException {
        String string = object.toString();
        if (!this.requiredLengths.containsKey(string.length())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : this.requiredLengths.keySet()) {
                stringBuilder.append(n + ", ");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 2);
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not of any of the required lengths " + stringBuilder.toString());
        }
        return this.next.execute(object, cSVContext);
    }
}

