/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.NullObjectPattern;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class Trim
extends CellProcessorAdaptor
implements StringCellProcessor {
    int maxSize;
    String trimPostfix = "";

    public Trim(int n) {
        super(NullObjectPattern.INSTANCE);
        if (n < 1) {
            throw new SuperCSVException("argument maxSize must be > 0");
        }
        this.maxSize = n;
    }

    public Trim(int n, String string) {
        this(n);
        this.trimPostfix = string;
    }

    public Trim(int n, String string, StringCellProcessor stringCellProcessor) {
        this(n, stringCellProcessor);
        this.trimPostfix = string;
    }

    public Trim(int n, StringCellProcessor stringCellProcessor) {
        super(stringCellProcessor);
        this.maxSize = n;
    }

    public Object execute(Object object, CSVContext cSVContext) {
        String string = object.toString();
        String string2 = string.length() <= this.maxSize ? string : string.substring(0, this.maxSize) + this.trimPostfix;
        return this.next.execute(string2, cSVContext);
    }
}

