/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Messages;
import net.murakamin.sticker.commands.exception.CommandExecutionException;

final class ConnectionPoolImpl
implements ConnectionPool {
    private String currentConnectionName = null;
    private Connection hsqlDbConnection = null;
    private final List<String> localTableNames = new Vector<String>();
    private final Map<String, Connection> remoteConnections = new Hashtable<String, Connection>();

    ConnectionPoolImpl() {
    }

    public void addLocalTableName(String localTableName) {
        this.localTableNames.add(localTableName);
    }

    void connectToHsqlDb() throws ClassNotFoundException, SQLException {
        String connectURL = "jdbc:hsqldb:mem:sticker;shutdown=false";
        Class.forName("org.hsqldb.jdbcDriver");
        this.hsqlDbConnection = DriverManager.getConnection(connectURL, "sa", "");
    }

    void connectToHsqlDb(File dataFile) throws ClassNotFoundException, SQLException {
        String connectURL = "jdbc:hsqldb:file:/$$DataFile$$/sticker;shutdown=true";
        Class.forName("org.hsqldb.jdbcDriver");
        connectURL = connectURL.replace("$$DataFile$$", dataFile.getAbsolutePath());
        this.hsqlDbConnection = DriverManager.getConnection(connectURL, "sa", "");
    }

    public void disConnectAllConnections() throws SQLException {
        this.disConnectToHsqlDb();
        this.disConnectToRemoteConnections();
    }

    protected void disConnectToHsqlDb() {
        if (this.hsqlDbConnection != null) {
            try {
                try {
                    if (!this.hsqlDbConnection.isClosed()) {
                        try {
                            this.hsqlDbConnection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SQLException se) {
                    throw new UnsupportedOperationException(se);
                }
            }
            finally {
                this.hsqlDbConnection = null;
            }
        }
    }

    public void disConnectToRemoteConnections() throws SQLException {
        for (Connection con : this.remoteConnections.values()) {
            if (con == null || con.isClosed()) continue;
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean existsLocalTable(String localTableName) {
        return this.localTableNames.contains(localTableName);
    }

    public Connection getLocalConnection() throws CommandExecutionException {
        return this.hsqlDbConnection;
    }

    public Connection getRemoteConnection() throws CommandExecutionException {
        Connection result = this.remoteConnections.get(this.currentConnectionName);
        if (result == null) {
            throw new CommandExecutionException(String.valueOf(Messages.getString("sticker.err.net.murakamin.sticker.ConnectionPoolImpl.cantfindconnection")) + this.currentConnectionName);
        }
        return result;
    }

    public void setCurrentConnectionName(String name) {
        this.currentConnectionName = name;
    }

    public void setRemoteConnection(String name, Connection con) throws CommandExecutionException {
        if (this.remoteConnections.containsKey(name)) {
            throw new CommandExecutionException(String.valueOf(Messages.getString("sticker.err.net.murakamin.sticker.ConnectionPoolImpl.duplicateconnection")) + name);
        }
        this.remoteConnections.put(name, con);
    }
}

