/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import net.argius.stew.Logger;
import net.argius.stew.text.TextUtilities;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionKey;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.Utilities;

final class ConsoleTextArea
extends JTextArea
implements AnyActionListener,
TextSearch {
    private static final Logger log = Logger.getLogger(ConsoleTextArea.class);
    private static final String BREAK_PROMPT = "[BREAK] > ";
    private final AnyActionListener anyActionListener;
    private final UndoManager undoManager;
    private int homePosition;

    ConsoleTextArea(AnyActionListener anyActionListener) {
        this.anyActionListener = anyActionListener;
        this.undoManager = AnyAction.setUndoAction(this);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new ConsoleTextAreaDocumentFilter());
        int n = Utilities.getMenuShortcutKeyMask();
        AnyAction anyAction = new AnyAction(this);
        anyAction.setUndoAction();
        anyAction.bindSelf((Object)ActionKey.submit, KeyStroke.getKeyStroke(10, 0));
        anyAction.bindSelf((Object)ActionKey.copyOrBreak, KeyStroke.getKeyStroke(67, n));
        anyAction.bindSelf((Object)AnyActionKey.breakCommand, KeyStroke.getKeyStroke(66, 512));
        anyAction.bindSelf((Object)ActionKey.addNewLine, KeyStroke.getKeyStroke(10, n));
        anyAction.bindSelf((Object)ActionKey.jumpToHomePosition, KeyStroke.getKeyStroke(36, 0));
        class DropTargetAdapterImpl
        extends DropTargetAdapter {
            DropTargetAdapterImpl() {
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    try {
                        StringBuilder stringBuilder = new StringBuilder();
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        for (File file : list) {
                            stringBuilder.append(file.getAbsolutePath()).append(" ");
                        }
                        ConsoleTextArea.this.append(stringBuilder.toString());
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        throw new RuntimeException(unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }
        this.setDropTarget(new DropTarget(this, new DropTargetAdapterImpl()));
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        log.atEnter("anyActionPerformed", anyActionEvent);
        if (anyActionEvent.isAnyOf(new Object[]{ActionKey.submit})) {
            int n = this.getEndPosition();
            if (this.getCaretPosition() == n) {
                this.anyActionListener.anyActionPerformed(new AnyActionEvent((Object)this, (Object)AnyActionKey.execute, new Object[0]));
            } else {
                this.setCaretPosition(n);
            }
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.copyOrBreak})) {
            if (this.getSelectedText() == null) {
                this.sendBreak();
            } else {
                DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
                copyAction.actionPerformed(anyActionEvent);
            }
        } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.breakCommand})) {
            this.sendBreak();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.addNewLine})) {
            this.insert("\n", this.getCaretPosition());
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.jumpToHomePosition})) {
            this.setCaretPosition(this.getHomePosition());
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.insertText})) {
            if (!this.isEditablePosition(this.getCaretPosition())) {
                this.setCaretPosition(this.getEndPosition());
            }
            this.replaceSelection(TextUtilities.join(" ", Arrays.asList(anyActionEvent.getArgs())));
            this.requestFocus();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.outputMessage})) {
            for (Object object : anyActionEvent.getArgs()) {
                this.output(String.valueOf(object));
            }
        } else if (!anyActionEvent.isAnyOf(new Object[]{ActionKey.doNothing})) {
            log.warn("not expected: Event=%s", anyActionEvent);
        }
        log.atExit("anyActionPerformed");
    }

    boolean canUndo() {
        return this.undoManager.canUndo();
    }

    boolean canRedo() {
        return this.undoManager.canRedo();
    }

    void append(String string, boolean bl) {
        super.append(string);
        if (bl) {
            this.setCaretPosition(this.getEndPosition());
        }
    }

    void output(String string) {
        super.append(string);
        this.undoManager.discardAllEdits();
        this.homePosition = this.getEndPosition();
        this.setCaretPosition(this.homePosition);
    }

    void replace(String string) {
        this.replaceRange(string, this.homePosition, this.getEndPosition());
    }

    void prepareSubmitting() {
        int n = this.getEndPosition();
        this.setSelectionStart(n);
        this.moveCaretPosition(n);
        this.requestFocus();
    }

    void clear() {
        this.homePosition = 0;
        this.setText("");
    }

    String getEditableText() {
        try {
            return this.getText(this.homePosition, this.getEndPosition() - this.homePosition);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    boolean isEditablePosition(int n) {
        return n >= this.homePosition;
    }

    int getHomePosition() {
        return this.homePosition;
    }

    int getEndPosition() {
        Document document = this.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    void resetHomePosition() {
        this.undoManager.discardAllEdits();
        this.homePosition = this.getEndPosition();
    }

    void sendBreak() {
        this.append(BREAK_PROMPT);
        this.resetHomePosition();
        this.validate();
    }

    @Override
    public void updateUI() {
        if (this.getCaret() == null) {
            super.updateUI();
        } else {
            int n = this.getCaretPosition();
            super.updateUI();
            this.setCaretPosition(n);
        }
    }

    @Override
    public boolean search(TextSearch.Matcher matcher) {
        this.removeHighlights();
        try {
            Highlighter highlighter = this.getHighlighter();
            Highlighter.HighlightPainter highlightPainter = TextSearch.Matcher.getHighlightPainter();
            String string = this.getText();
            int n = 0;
            boolean bl = false;
            while (matcher.find(string, n)) {
                bl = true;
                int n2 = matcher.getStart();
                highlighter.addHighlight(n2, matcher.getEnd(), highlightPainter);
                n = n2 + 1;
            }
            this.addKeyListener(new TextSearchKeyListener());
            return bl;
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    @Override
    public void reset() {
        this.removeHighlights();
    }

    void removeHighlights() {
        for (Highlighter.Highlight highlight : this.getHighlighter().getHighlights()) {
            this.getHighlighter().removeHighlight(highlight);
        }
    }

    private final class TextSearchKeyListener
    extends KeyAdapter {
        TextSearchKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            ConsoleTextArea.this.removeKeyListener(this);
            ConsoleTextArea.this.removeHighlights();
        }
    }

    private final class ConsoleTextAreaDocumentFilter
    extends DocumentFilter {
        ConsoleTextAreaDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ConsoleTextArea.this.isEditablePosition(n)) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (ConsoleTextArea.this.isEditablePosition(n)) {
                super.remove(filterBypass, n, n2);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ConsoleTextArea.this.isEditablePosition(n)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }

    static enum ActionKey {
        submit,
        copyOrBreak,
        addNewLine,
        jumpToHomePosition,
        outputMessage,
        insertText,
        doNothing;

    }
}

