/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.argius.stew.Bootstrap;
import net.argius.stew.CommandException;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;
import net.argius.stew.command.Load;
import net.argius.stew.io.Importer;

public final class Import
extends Load {
    private static final Logger log = Logger.getLogger(Import.class);
    private static final String PROP_BATCH_LIMIT = "net.argius.stew.command.Import.batch.limit";
    private static final int DEFAULT_BATCH_LIMIT = 10000;

    @Override
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (!parameter.has(2)) {
            throw new UsageException(this.getUsage());
        }
        File file = this.resolvePath(parameter.at(1));
        String string = parameter.at(2);
        boolean bl = parameter.at(3).equalsIgnoreCase("HEADER");
        if (log.isDebugEnabled()) {
            log.debug("file: " + file.getAbsolutePath());
            log.debug("table: " + string);
            log.debug("hasHeader: " + bl);
        }
        try {
            this.loadRecord(connection, file, string, bl);
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException.getNextException();
            if (sQLException2 != null && sQLException2 != sQLException) {
                log.error(sQLException2, "next exception: ");
            }
            throw new CommandException(sQLException);
        }
    }

    @Override
    protected void insertRecords(PreparedStatement preparedStatement, Importer importer) throws IOException, SQLException {
        int n = Bootstrap.getPropertyAsInt(PROP_BATCH_LIMIT, 10000);
        if (log.isDebugEnabled()) {
            log.debug("batch limit = " + n);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            Object[] objectArray;
            boolean bl;
            boolean bl2 = bl = (objectArray = importer.nextRow()).length == 0;
            if (!bl) {
                ++n2;
                try {
                    for (n5 = 0; n5 < objectArray.length; ++n5) {
                        preparedStatement.setObject(n5 + 1, objectArray[n5]);
                    }
                    preparedStatement.addBatch();
                }
                catch (SQLException sQLException) {
                    String string = "error occurred at " + n2;
                    if (log.isTraceEnabled()) {
                        log.trace(string, (Object)sQLException);
                    } else if (log.isDebugEnabled()) {
                        log.debug(string + " : " + sQLException);
                    }
                    ++n4;
                }
            }
            if (n2 % n != 0 && !bl) continue;
            n5 = Import.executeBatch(preparedStatement);
            n3 += n5;
            if (log.isDebugEnabled()) {
                log.debug("record/inserted = " + n2 + "/" + n3);
            }
            if (bl) break;
        }
        if (n4 > 0) {
            log.warn("error count = " + n4, new Object[0]);
        }
        this.outputMessage("i.loaded", n3, n2);
    }

    private static int executeBatch(PreparedStatement preparedStatement) throws SQLException {
        int[] nArray = preparedStatement.executeBatch();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            switch (n4) {
                case 1: {
                    ++n;
                    continue block5;
                }
                case -2: {
                    ++n2;
                    ++n;
                    continue block5;
                }
                case -3: {
                    ++n3;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("result=" + n4);
                }
            }
        }
        if (n3 > 0) {
            log.warn("failedCount = " + n3, new Object[0]);
        }
        if (n2 > 0) {
            log.warn("noInfoCount = " + n2, new Object[0]);
        }
        if (n != nArray.length) {
            log.warn("array size = " + nArray.length + ", but result count = " + n, new Object[0]);
        }
        preparedStatement.clearBatch();
        return n;
    }
}

