/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.TreeSet;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.argius.stew.AliasMap;
import net.argius.stew.AnonymousConnector;
import net.argius.stew.Bootstrap;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Connector;
import net.argius.stew.DynamicLoader;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.Environment;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.ResourceManager;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.io.Path;
import net.argius.stew.ui.OutputProcessor;

final class CommandProcessor {
    private static Logger log = Logger.getLogger(CommandProcessor.class);
    private static ResourceManager res = ResourceManager.getInstance(Command.class);
    private static final String HYPHEN_E = "-e";
    private final Environment env;
    private final OutputProcessor op;

    CommandProcessor(Environment environment) {
        this.env = environment;
        this.op = environment.getOutputProcessor();
    }

    boolean invoke(String string) throws CommandException {
        Throwable throwable;
        Parameter parameter = new Parameter(string);
        if (string.replaceFirst("^\\s+", "").startsWith(HYPHEN_E)) {
            int n = string.indexOf(HYPHEN_E) + 2;
            for (String string2 : string.substring(n).split(HYPHEN_E)) {
                this.op.output(" >> " + string2);
                if (this.invoke(string2)) continue;
                this.outputMessage("w.exit-not-available-in-sequencial-command", new Object[0]);
            }
            return true;
        }
        String string3 = parameter.at(0);
        try {
            return this.invoke(string3, new Parameter(string));
        }
        catch (UsageException usageException) {
            this.outputMessage("e.usage", string3, usageException.getMessage());
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            log.error(dynamicLoadingException);
            this.outputMessage("e.not-found", string3);
        }
        catch (CommandException commandException) {
            log.error(commandException);
            throwable = commandException.getCause();
            String string4 = throwable == null ? commandException.getMessage() : throwable.getMessage();
            this.outputMessage("e.command", string4);
        }
        catch (IOException iOException) {
            log.error(iOException);
            this.outputMessage("e.command", iOException.getMessage());
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            log.error(sQLException);
            throwable = sQLException;
            while ((sQLException2 = ((SQLException)throwable).getNextException()) != null && sQLException2 != throwable) {
                log.error(sQLException2, "------ SQLException.getNextException ------");
                throwable = sQLException2;
            }
            this.outputMessage("e.database", sQLException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.warn(unsupportedOperationException);
            this.outputMessage("e.unsupported", unsupportedOperationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            log.error(runtimeException);
            this.outputMessage("e.runtime", runtimeException.getMessage());
        }
        catch (Throwable throwable2) {
            log.fatal(throwable2);
            this.outputMessage("e.fatal", throwable2.getMessage());
        }
        try {
            boolean bl;
            Connection connection = this.env.getCurrentConnection();
            if (connection != null && (bl = connection.isClosed())) {
                log.info("connection is already closed");
                this.disconnect();
            }
        }
        catch (SQLException sQLException) {
            log.warn(sQLException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invoke(String string, Parameter parameter) throws IOException, SQLException {
        assert (string != null);
        if (string.length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("exit")) {
            this.disconnect();
            this.outputMessage("i.exit", new Object[0]);
            return false;
        }
        if (string.equalsIgnoreCase("connect") || string.equalsIgnoreCase("-c")) {
            this.connect(parameter);
            return true;
        }
        if (string.equals("-f")) {
            if (!parameter.has(1)) {
                throw new UsageException(res.get("usage.-f", new Object[0]));
            }
            Path path = Path.resolve(this.env.getCurrentDirectory(), parameter.at(1));
            String string2 = path.getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug("absolute path = [%s]", (Object)string2);
            }
            if (!path.isFile()) {
                this.outputMessage("e.file-not-exists", string2);
                throw new UsageException(res.get("usage.-f", new Object[0]));
            }
            log.debug("-f %s", (Object)path.getAbsolutePath());
            this.invoke(String.format("%s%s", Command.readFileAsString(path), parameter.after(2)));
            return true;
        }
        if (string.equals("-s")) {
            block55: {
                ScriptEngine scriptEngine;
                Path path;
                if (!parameter.has(1)) {
                    throw new UsageException(res.get("usage.-s", new Object[0]));
                }
                String string3 = parameter.at(1);
                if (string3.equals(".")) {
                    this.env.initializeScriptContext();
                    this.outputMessage("i.script-context-initialized", new Object[0]);
                    return true;
                }
                if (string3.contains(".")) {
                    path = Path.resolve(this.env.getCurrentDirectory(), string3);
                    if (!path.exists() || !path.isFile()) {
                        this.outputMessage("e.file-not-exists", string3);
                        return true;
                    }
                    log.debug("script file: %s", (Object)path.getAbsolutePath());
                } else {
                    path = null;
                    log.debug("script name: %s", (Object)string3);
                }
                ScriptEngine scriptEngine2 = scriptEngine = path == null ? new ScriptEngineManager().getEngineByName(string3) : new ScriptEngineManager().getEngineByExtension(Path.getExtension(path));
                if (scriptEngine == null) {
                    this.outputMessage("e.unsupported", string3);
                    return true;
                }
                scriptEngine.setContext(this.env.getScriptContext());
                scriptEngine.put("connection", this.env.getCurrentConnection());
                scriptEngine.put("conn", this.env.getCurrentConnection());
                scriptEngine.put("patameter", parameter);
                scriptEngine.put("p", parameter);
                scriptEngine.put("outputProcessor", this.op);
                scriptEngine.put("op", this.op);
                try {
                    if (path == null) {
                        scriptEngine.put("javax.script.filename", null);
                        scriptEngine.eval(parameter.after(2));
                        break block55;
                    }
                    scriptEngine.put("javax.script.filename", path.getAbsolutePath());
                    FileReader fileReader = new FileReader(path);
                    try {
                        scriptEngine.eval(fileReader);
                    }
                    finally {
                        ((Reader)fileReader).close();
                    }
                }
                catch (Exception exception) {
                    throw new CommandException(exception);
                }
            }
            return true;
        }
        AliasMap aliasMap = this.env.getAliasMap();
        if (string.equalsIgnoreCase("alias") || string.equalsIgnoreCase("unalias")) {
            aliasMap.reload();
            if (string.equalsIgnoreCase("alias")) {
                if (parameter.has(2)) {
                    String string4 = parameter.at(1);
                    if (CommandProcessor.isUsableKeywordForAlias(string4)) {
                        this.outputMessage("w.unusable-keyword-for-alias", string4);
                        return true;
                    }
                    aliasMap.setValue(string4, parameter.after(2));
                    aliasMap.save();
                } else if (parameter.has(1)) {
                    String string5 = parameter.at(1);
                    if (CommandProcessor.isUsableKeywordForAlias(string5)) {
                        this.outputMessage("w.unusable-keyword-for-alias", string5);
                        return true;
                    }
                    if (aliasMap.containsKey(string5)) {
                        this.outputMessage("i.dump-alias", string5, aliasMap.getValue(string5));
                    }
                } else if (aliasMap.isEmpty()) {
                    this.outputMessage("i.noalias", new Object[0]);
                } else {
                    for (String string6 : new TreeSet<String>(aliasMap.keys())) {
                        this.outputMessage("i.dump-alias", string6, aliasMap.getValue(string6));
                    }
                }
            } else if (string.equalsIgnoreCase("unalias")) {
                if (parameter.has(1)) {
                    aliasMap.remove(parameter.at(1));
                    aliasMap.save();
                } else {
                    throw new UsageException(res.get("usage.unalias", new Object[0]));
                }
            }
            return true;
        }
        if (aliasMap.containsKey(string)) {
            String string7 = aliasMap.expand(string, parameter);
            this.op.output(" >> " + string7);
            this.invoke(string7);
            return true;
        }
        if (string.equalsIgnoreCase("cd")) {
            if (!parameter.has(1)) {
                throw new UsageException(res.get("usage.cd", new Object[0]));
            }
            File file = this.env.getCurrentDirectory();
            String string8 = parameter.at(1);
            File file2 = new File(string8);
            File file3 = (file2.isAbsolute() ? file2 : new File(file, string8)).getCanonicalFile();
            if (!file3.isDirectory()) {
                this.outputMessage("e.dir-not-exists", file3);
                return true;
            }
            this.env.setCurrentDirectory(file3);
            this.outputMessage("i.directory-changed", file.getAbsolutePath(), file3.getAbsolutePath());
            return true;
        }
        if (string.equals("@")) {
            String string9 = this.env.getCurrentDirectory().getAbsolutePath();
            String string10 = Bootstrap.getSystemDirectory().getAbsolutePath();
            this.op.output(String.format("current dir : %s", string9));
            this.op.output(String.format("system  dir : %s", string10));
            return true;
        }
        if (string.equals("-")) {
            return this.invoke("report -");
        }
        if (string.equals("?")) {
            if (parameter.has(1)) {
                for (String string11 : parameter.asArray()) {
                    if (string11.equals("?")) continue;
                    String string12 = System.getProperties().containsKey(string11) ? String.format("[%s]", System.getProperty(string11)) : "undefined";
                    this.op.output(String.format("%s=%s", string11, string12));
                }
            } else {
                this.op.output(String.format("JRE : %s %s", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
                this.op.output(String.format("OS : %s (osver=%s)", System.getProperty("os.name"), System.getProperty("os.version")));
                this.op.output(String.format("Locale : %s", Locale.getDefault()));
            }
            return true;
        }
        Connection connection = this.env.getCurrentConnection();
        if (connection == null) {
            this.outputMessage("e.not-connect", new Object[0]);
        } else if (string.equalsIgnoreCase("disconnect") || string.equalsIgnoreCase("-d")) {
            this.disconnect();
            this.outputMessage("i.disconnected", new Object[0]);
        } else if (string.equalsIgnoreCase("commit")) {
            connection.commit();
            this.outputMessage("i.committed", new Object[0]);
        } else if (string.equalsIgnoreCase("rollback")) {
            connection.rollback();
            this.outputMessage("i.rollbacked", new Object[0]);
        } else {
            this.executeDynamicCommand(string, connection, parameter);
        }
        return true;
    }

    private static boolean isUsableKeywordForAlias(String string) {
        return string != null && string.matches("(?i)-.*|exit|alias|unalias");
    }

    private void connect(Parameter parameter) throws SQLException {
        log.info("connect start");
        this.disconnect();
        String string = parameter.at(1);
        Connector connector = !parameter.has(1) ? AnonymousConnector.getConnector(string, parameter.at(2), parameter.at(3)) : (string.indexOf(64) >= 0 ? AnonymousConnector.getConnector(string) : this.env.getConnectorMap().getConnector(string));
        if (connector != null) {
            this.env.establishConnection(connector);
        } else {
            this.outputMessage("e.no-connector", string);
        }
        log.info("connect end");
    }

    private void disconnect() {
        log.debug("disconnect start");
        try {
            this.env.releaseConnection();
        }
        catch (SQLException sQLException) {
            this.outputMessage("w.connection-closed-abnormally", new Object[0]);
        }
        log.debug("disconnect end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDynamicCommand(String string, Connection connection, Parameter parameter) {
        Class<Object> clazz;
        assert (string != null && !string.contains(" "));
        String string2 = string.indexOf(46) > 0 ? string : "net.argius.stew.command." + string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        try {
            clazz = DynamicLoader.loadClass(string2);
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            clazz = Command.isSelect(parameter.asString()) ? Select.class : UpdateAndOthers.class;
        }
        Command command = (Command)DynamicLoader.newInstance(clazz);
        try {
            Connector connector = this.env.getCurrentConnector();
            if (connector.isReadOnly() && !command.isReadOnly()) {
                this.outputMessage("e.readonly", new Object[0]);
                return;
            }
            command.setEnvironment(this.env);
            log.info("command: %s start", (Object)command);
            log.debug(parameter);
            command.initialize();
            command.execute(connection, parameter);
        }
        finally {
            command.close();
        }
        log.info("command: %s end", (Object)command);
    }

    void outputMessage(String string, Object ... objectArray) throws CommandException {
        this.op.output(res.get(string, objectArray));
    }

    static final class UpdateAndOthers
    extends RawSQL {
        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        protected void execute(Statement statement, String string) throws SQLException {
            int n = this.executeUpdate(statement, string);
            String string2 = string.matches("(?i)\\s*UPDATE.*") ? "i.updated" : (string.matches("(?i)\\\\s*INSERT.*") ? "i.inserted" : (string.matches("(?i)\\\\s*DELETE.*") ? "i.deleted" : "i.proceeded"));
            this.outputMessage(string2, n);
        }
    }

    static final class Select
    extends RawSQL {
        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Statement statement, String string) throws SQLException {
            long l = System.currentTimeMillis();
            ResultSet resultSet = this.executeQuery(statement, string);
            try {
                this.outputMessage("i.response-time", Float.valueOf((float)(System.currentTimeMillis() - l) / 1000.0f));
                ResultSetReference resultSetReference = new ResultSetReference(resultSet, string);
                this.output(resultSetReference);
                this.outputMessage("i.selected", resultSetReference.getRecordCount());
            }
            finally {
                resultSet.close();
            }
        }
    }

    static abstract class RawSQL
    extends Command {
        RawSQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void execute(Connection connection, Parameter parameter) throws CommandException {
            String string = parameter.asString();
            try {
                Statement statement = this.prepareStatement(connection, string);
                try {
                    this.execute(statement, string);
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CommandException(sQLException);
            }
        }

        protected abstract void execute(Statement var1, String var2) throws SQLException;
    }
}

