/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.Menu;

final class ContextMenu {
    private static final Logger log = Logger.getLogger(ContextMenu.class);
    private static final ResourceManager res = ResourceManager.getInstance(ContextMenu.class);

    private ContextMenu() {
    }

    static JPopupMenu create(JComponent jComponent, AnyActionListener anyActionListener) {
        return ContextMenu.create(jComponent, anyActionListener, jComponent.getClass().getSimpleName());
    }

    static JPopupMenu create(AnyActionListener anyActionListener) {
        JComponent jComponent = anyActionListener instanceof JComponent ? (JComponent)((Object)anyActionListener) : null;
        return ContextMenu.create(jComponent, anyActionListener, anyActionListener.getClass().getSimpleName());
    }

    static JPopupMenu create(JComponent jComponent, AnyActionListener anyActionListener, String string) {
        log.atEnter("set", anyActionListener, string);
        JPopupMenu jPopupMenu = new JPopupMenu();
        Map<String, KeyStroke> map = ContextMenu.extractKeyBinds(jComponent);
        AnyAction anyAction = new AnyAction(anyActionListener);
        for (JMenuItem jMenuItem : Menu.createJMenuItems(res, string)) {
            if (jMenuItem == null) {
                jPopupMenu.add(new JSeparator());
                continue;
            }
            jMenuItem.addActionListener(anyAction);
            String string2 = jMenuItem.getActionCommand();
            if (map.containsKey(string2)) {
                jMenuItem.setAccelerator(map.get(string2));
            }
            jPopupMenu.add(jMenuItem);
        }
        if (jComponent == null && anyActionListener instanceof JComponent) {
            ((JComponent)((Object)anyActionListener)).setComponentPopupMenu(jPopupMenu);
        } else if (jComponent != null) {
            jComponent.setComponentPopupMenu(jPopupMenu);
        }
        if (anyActionListener instanceof PopupMenuListener) {
            jPopupMenu.addPopupMenuListener((PopupMenuListener)((Object)anyActionListener));
        }
        return log.atExit("set", jPopupMenu);
    }

    private static Map<String, KeyStroke> extractKeyBinds(JComponent jComponent) {
        KeyStroke[] keyStrokeArray;
        InputMap inputMap;
        HashMap<String, KeyStroke> hashMap = new HashMap<String, KeyStroke>();
        if (jComponent != null && (inputMap = jComponent.getInputMap()) != null && (keyStrokeArray = inputMap.allKeys()) != null) {
            for (KeyStroke keyStroke : keyStrokeArray) {
                hashMap.put(String.valueOf(inputMap.get(keyStroke)), keyStroke);
            }
        }
        return hashMap;
    }

    static JPopupMenu createForText(JTextComponent jTextComponent) {
        AnyAction anyAction = new AnyAction(jTextComponent);
        return ContextMenu.createForText(jTextComponent, anyAction.setUndoAction());
    }

    static JPopupMenu createForText(JTextComponent jTextComponent, UndoManager undoManager) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        TextPopupMenuListener textPopupMenuListener = new TextPopupMenuListener(jTextComponent, undoManager);
        for (JMenuItem jMenuItem : Menu.createJMenuItems(res, "TextComponent")) {
            if (jMenuItem == null) {
                jPopupMenu.add(new JSeparator());
                continue;
            }
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(textPopupMenuListener);
            textPopupMenuListener.putPopupMenuItem(jMenuItem.getActionCommand(), jMenuItem);
        }
        jPopupMenu.addPopupMenuListener(textPopupMenuListener);
        jTextComponent.setComponentPopupMenu(jPopupMenu);
        return jPopupMenu;
    }

    static enum ActionKey {
        copySimpleName,
        copyFullName,
        generateWherePhrase,
        generateSelectPhrase,
        generateUpdateStatement,
        generateInsertStatement,
        jumpToColumnByName,
        toggleShowColumnNumber,
        copyWithEscape,
        clearSelectedCellValue,
        setCurrentTimeValue,
        copyColumnName,
        findColumnName,
        addEmptyRow,
        insertFromClipboard,
        duplicateRows,
        linkRowsToDatabase,
        deleteRows,
        adjustColumnWidth,
        sort,
        doNothing,
        submit,
        copyOrBreak,
        addNewLine,
        jumpToHomePosition,
        outputMessage,
        insertText,
        cut,
        copy,
        paste,
        selectAll,
        undo,
        redo,
        execute,
        refresh,
        newWindow,
        closeWindow,
        quit,
        find,
        toggleFocus,
        clearMessage,
        showStatusBar,
        showInfoTree,
        showColumnNumber,
        showAlwaysOnTop,
        widenColumnWidth,
        narrowColumnWidth,
        executeCommand,
        breakCommand,
        lastHistory,
        nextHistory,
        sendRollback,
        sendCommit,
        connect,
        disconnect,
        inputEcryptionKey,
        editConnectors,
        sortResult,
        importFile,
        exportFile,
        showHelp,
        showAbout;

    }

    static final class TextPopupMenuListener
    implements ActionListener,
    PopupMenuListener {
        private final JTextComponent text;
        private final UndoManager um;
        private final Map<String, JMenuItem> itemMap;

        TextPopupMenuListener(JTextComponent jTextComponent, UndoManager undoManager) {
            this.text = jTextComponent;
            this.um = undoManager;
            this.itemMap = new HashMap<String, JMenuItem>();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            String string2 = string.equals("cut") ? "cut-to-clipboard" : (string.equals("copy") ? "copy-to-clipboard" : (string.equals("paste") ? "paste-from-clipboard" : (string.equals("selectAll") ? "select-all" : string)));
            this.text.getActionMap().get(string2).actionPerformed(actionEvent);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.itemMap.get("undo").setEnabled(this.um.canUndo());
            this.itemMap.get("redo").setEnabled(this.um.canRedo());
            boolean bl = this.text.getSelectionEnd() > this.text.getSelectionStart();
            this.itemMap.get("cut").setEnabled(bl);
            this.itemMap.get("copy").setEnabled(bl);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        void putPopupMenuItem(String string, JMenuItem jMenuItem) {
            this.itemMap.put(string, jMenuItem);
        }
    }
}

