/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableModel;
import net.argius.stew.ColumnOrder;
import net.argius.stew.DaemonThreadFactory;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ResultSetReference;
import net.argius.stew.text.TextUtilities;
import net.argius.stew.ui.window.ValueTransporter;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ResultSetTableModel
extends DefaultTableModel {
    private static final Logger log = Logger.getLogger(ResultSetTableModel.class);
    private static final long serialVersionUID = -8861356207097438822L;
    private static final String PTN1 = "\\s*SELECT\\s.+?\\sFROM\\s+([^\\s]+).*";
    private final int[] types;
    private final String commandString;
    private Connection conn;
    private Object tableName;
    private String[] primaryKeys;
    private boolean updatable;
    private boolean linkable;

    ResultSetTableModel(ResultSetReference resultSetReference) throws SQLException {
        super(0, ResultSetTableModel.getColumnCount(resultSetReference));
        ResultSet resultSet = resultSetReference.getResultSet();
        ColumnOrder columnOrder = resultSetReference.getOrder();
        String string = resultSetReference.getCommandString();
        boolean bl = columnOrder.size() == 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = this.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            String string2;
            int n2;
            if (bl) {
                n2 = resultSetMetaData.getColumnType(i + 1);
                string2 = resultSetMetaData.getColumnName(i + 1);
            } else {
                n2 = resultSetMetaData.getColumnType(columnOrder.getOrder(i));
                string2 = columnOrder.getName(i);
            }
            nArray[i] = n2;
            String string3 = this.columnIdentifiers.set(i, string2);
        }
        this.types = nArray;
        this.commandString = string;
        try {
            this.analyzeForLinking(resultSet, string);
        }
        catch (Exception exception) {
            log.warn(exception);
        }
    }

    private static int getColumnCount(ResultSetReference resultSetReference) throws SQLException {
        int n = resultSetReference.getOrder().size();
        return n == 0 ? resultSetReference.getResultSet().getMetaData().getColumnCount() : n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (this.types[n]) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.primaryKeys == null || this.primaryKeys.length == 0) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl;
        if (!this.linkable) {
            return;
        }
        Object object2 = this.getValueAt(n, n2);
        if (object == null) {
            bl = object != object2;
        } else {
            boolean bl2 = bl = !object.equals(object2);
        }
        if (bl) {
            if (this.isLinkedRow(n)) {
                Object[] objectArray = this.columnIdentifiers.toArray();
                try {
                    this.executeUpdate(this.getRowData(objectArray, n), objectArray[n2], object);
                }
                catch (Exception exception) {
                    log.error(exception);
                    throw new RuntimeException(exception);
                }
            } else if (log.isTraceEnabled()) {
                log.debug("update unlinked row");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("skip to update");
        }
        super.setValueAt(object, n, n2);
    }

    void addUnlinkedRow(Object[] objectArray) {
        this.addUnlinkedRow(ResultSetTableModel.convertToVector(objectArray));
    }

    void addUnlinkedRow(Vector<?> vector) {
        this.addRow(new UnlinkedRow(vector));
    }

    void insertUnlinkedRow(int n, Object[] objectArray) {
        this.insertUnlinkedRow(n, new UnlinkedRow(objectArray));
    }

    void insertUnlinkedRow(int n, Vector<?> vector) {
        this.insertRow(n, new UnlinkedRow(vector));
    }

    boolean linkRow(int n) throws SQLException {
        if (this.isLinkedRow(n)) {
            return false;
        }
        this.executeInsert(this.getRowData(this.columnIdentifiers.toArray(), n));
        Vector<Vector> vector = this.getDataVector();
        vector.set(n, new Vector(vector.get(n)));
        return true;
    }

    boolean removeLinkedRow(int n) throws SQLException {
        if (!this.isLinkedRow(n)) {
            return false;
        }
        this.executeDelete(this.getRowData(this.columnIdentifiers.toArray(), n));
        super.removeRow(n);
        return true;
    }

    private Map<Object, Object> getRowData(Object[] objectArray, int n) {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            linkedHashMap.put(objectArray[i], this.getValueAt(n, i));
        }
        return linkedHashMap;
    }

    void sort(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        Vector<Vector> vector = this.getDataVector();
        Collections.sort(vector, new RowComparator(n2, n));
    }

    boolean isUpdatable() {
        return this.updatable;
    }

    boolean isLinkable() {
        return this.linkable;
    }

    boolean isLinkedRow(int n) {
        return !(this.getDataVector().get(n) instanceof UnlinkedRow);
    }

    boolean hasUnlinkedRows() {
        for (Vector vector : this.getDataVector()) {
            if (!(vector instanceof UnlinkedRow)) continue;
            return true;
        }
        return false;
    }

    boolean isSameConnection(Connection connection) {
        return connection == this.conn;
    }

    String getCommandString() {
        return this.commandString;
    }

    private void executeUpdate(Map<Object, Object> map, Object object, Object object2) throws SQLException {
        String string = String.format("UPDATE %s SET %s=? WHERE %s", this.tableName, ResultSetTableModel.quoteIfNeeds(object), ResultSetTableModel.toKeyPhrase(this.primaryKeys));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object2);
        for (String string2 : this.primaryKeys) {
            arrayList.add(map.get(string2));
        }
        this.executeSql(string, arrayList.toArray());
    }

    private void executeInsert(Map<Object, Object> map) throws SQLException {
        int n = map.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            arrayList.add(ResultSetTableModel.quoteIfNeeds(String.valueOf(entry.getKey())));
            arrayList2.add(entry.getValue());
        }
        String string = String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableName, TextUtilities.join(",", arrayList), TextUtilities.join(",", Collections.nCopies(n, "?")));
        this.executeSql(string, arrayList2.toArray());
    }

    private void executeDelete(Map<Object, Object> map) throws SQLException {
        String string = String.format("DELETE FROM %s WHERE %s", this.tableName, ResultSetTableModel.toKeyPhrase(this.primaryKeys));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string2 : this.primaryKeys) {
            arrayList.add(map.get(string2));
        }
        this.executeSql(string, arrayList.toArray());
    }

    private void executeSql(final String string, final Object[] objectArray) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("SQL: " + string);
            log.debug("parameters: " + Arrays.asList(objectArray));
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final ArrayList arrayList = new ArrayList();
        DaemonThreadFactory.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ResultSetTableModel.this.conn.isClosed()) {
                        throw new SQLException(ResourceManager.Default.get("e.not-connect", new Object[0]));
                    }
                    PreparedStatement preparedStatement = ResultSetTableModel.this.conn.prepareStatement(string);
                    try {
                        ValueTransporter valueTransporter = ValueTransporter.getInstance("");
                        int n = 0;
                        for (Object object : objectArray) {
                            boolean bl = false;
                            if ((object == null || String.valueOf(object).length() == 0) && ResultSetTableModel.this.getColumnClass(n) != String.class) {
                                bl = true;
                            }
                            ++n;
                            if (bl) {
                                preparedStatement.setNull(n, ResultSetTableModel.this.types[n - 1]);
                                continue;
                            }
                            valueTransporter.setObject(preparedStatement, n, object);
                        }
                        int n2 = preparedStatement.executeUpdate();
                        if (n2 != 1) {
                            throw new SQLException("updated count is not 1, but " + n2);
                        }
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    log.error(sQLException);
                    arrayList.add(sQLException);
                }
                catch (Throwable throwable) {
                    log.error(throwable);
                    SQLException sQLException = new SQLException();
                    sQLException.initCause(throwable);
                    arrayList.add(sQLException);
                }
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        if (countDownLatch.getCount() != 0L) {
            DaemonThreadFactory.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn(interruptedException);
                    }
                    if (!arrayList.isEmpty()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WindowOutputProcessor.showErrorDialog(null, (Throwable)arrayList.get(0));
                            }
                        });
                    }
                }
            });
        } else if (!arrayList.isEmpty()) {
            if (log.isDebugEnabled()) {
                for (SQLException sQLException : arrayList) {
                    log.debug("", (Object)sQLException);
                }
            }
            throw (SQLException)arrayList.get(0);
        }
    }

    private static String toKeyPhrase(Object[] objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (Object object : objectArray) {
            arrayList.add(String.format("%s=?", object));
        }
        return TextUtilities.join(" AND ", arrayList);
    }

    private static String quoteIfNeeds(Object object) {
        String string = String.valueOf(object);
        if (string.matches(".*\\W.*")) {
            return String.format("\"%s\"", string);
        }
        return string;
    }

    private void analyzeForLinking(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            return;
        }
        Statement statement = resultSet.getStatement();
        if (statement == null) {
            return;
        }
        Connection connection = statement.getConnection();
        if (connection == null) {
            return;
        }
        this.conn = connection;
        if (connection.isReadOnly()) {
            return;
        }
        String string2 = ResultSetTableModel.findTableName(string);
        if (string2.length() == 0) {
            return;
        }
        this.tableName = string2;
        this.updatable = true;
        List<String> list = ResultSetTableModel.findPrimaryKeys(connection, string2);
        if (list.isEmpty()) {
            return;
        }
        Vector vector = this.columnIdentifiers;
        if (!vector.containsAll(list)) {
            return;
        }
        if (ResultSetTableModel.findUnion(string)) {
            return;
        }
        this.primaryKeys = list.toArray(new String[list.size()]);
        this.linkable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findTableName(String string) {
        if (string != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            Scanner scanner = new Scanner(string);
            try {
                while (scanner.hasNextLine()) {
                    object = scanner.nextLine();
                    stringBuilder.append(((String)object).replaceAll("/\\*.*?\\*/|//.*", ""));
                    stringBuilder.append(' ');
                }
            }
            finally {
                scanner.close();
            }
            object = Pattern.compile(PTN1, 2);
            Matcher matcher = ((Pattern)object).matcher(stringBuilder);
            if (matcher.matches()) {
                String string2;
                String string3 = matcher.group(1);
                String[] stringArray = string3.split("\\s");
                boolean bl = false;
                for (int i = 0; i < 2 && i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (string4.indexOf(44) < 0) continue;
                    bl = true;
                }
                if (!bl && (string2 = stringArray[0]).matches("[A-Za-z0-9_\\.]+")) {
                    return string2;
                }
            }
        }
        return "";
    }

    private static List<String> findPrimaryKeys(Connection connection, String string) throws SQLException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Object object;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (string.contains(".")) {
            object = string.split("\\.");
            if (((String[])object).length >= 3) {
                string6 = object[0];
                string5 = object[1];
                string4 = object[2];
            } else {
                string6 = null;
                string5 = object[0];
                string4 = object[1];
            }
        } else {
            string6 = null;
            string5 = databaseMetaData.getUserName();
            string4 = string;
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            object = string6 == null ? null : string6.toLowerCase();
            string3 = string5 == null ? null : string5.toLowerCase();
            string2 = string4.toLowerCase();
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            object = string6 == null ? null : string6.toUpperCase();
            string3 = string5 == null ? null : string5.toUpperCase();
            string2 = string4.toUpperCase();
        } else {
            object = string6;
            string3 = string5;
            string2 = string4;
        }
        if (object == null && string3 == null) {
            return ResultSetTableModel.getPrimaryKeys(databaseMetaData, null, null, string2);
        }
        List<String> list = ResultSetTableModel.getPrimaryKeys(databaseMetaData, (String)object, string3, string2);
        if (list.isEmpty()) {
            return ResultSetTableModel.getPrimaryKeys(databaseMetaData, null, null, string2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPrimaryKeys(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(4));
                hashSet.add(resultSet.getString(2));
            }
            if (hashSet.size() != 1) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            resultSet.close();
        }
    }

    private static boolean findUnion(String string) {
        String string2 = string;
        if (string2.indexOf(39) >= 0) {
            if (string2.indexOf("\\'") >= 0) {
                string2 = string2.replaceAll("\\'", "");
            }
            string2 = string2.replaceAll("'[^']+'", "''");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equalsIgnoreCase("UNION")) continue;
            return true;
        }
        return false;
    }

    private static final class RowComparator
    implements Comparator<List<Object>> {
        private final int f;
        private final int columnIndex;

        RowComparator(int n, int n2) {
            this.f = n;
            this.columnIndex = n2;
        }

        @Override
        public int compare(List<Object> list, List<Object> list2) {
            return this.c(list, list2) * this.f;
        }

        private int c(List<Object> list, List<Object> list2) {
            if (list == null || list2 == null) {
                return list == null ? (list2 == null ? 0 : -1) : 1;
            }
            Object object = list.get(this.columnIndex);
            Object object2 = list2.get(this.columnIndex);
            if (object == null || object2 == null) {
                return object == null ? (object2 == null ? 0 : -1) : 1;
            }
            if (object instanceof Comparable && object.getClass() == object2.getClass()) {
                Comparable comparable = (Comparable)object;
                Comparable comparable2 = (Comparable)object2;
                return comparable.compareTo(comparable2);
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    private static final class UnlinkedRow
    extends Vector<Object> {
        UnlinkedRow(Vector<?> vector) {
            super(vector);
        }

        UnlinkedRow(Object[] objectArray) {
            super(objectArray.length);
            for (Object object : objectArray) {
                this.add(object);
            }
        }
    }
}

